#version 150 compatibility

#extension GL_ARB_explicit_attrib_location : enable
#extension GL_ARB_shader_image_load_store : enable

#define SHADOWPROG
#define OVERWORLD
#include "/includes/main.glsl"

#ifdef SHADOW_WAVE
    #include "/lib/vertex/main.glsl"
#endif

#if SHADOW_FILTERING == 2
flat out vec4 color;
#endif

#if defined DISTANT_HORIZONS && !defined SHADOW_DEBUG
out vec3 viewVector;
#endif
out float isflower;

in vec4 mc_Entity;
in vec4 mc_midTexCoord;

#ifdef LPV_ENABLED
    #define SHADOW_MAP_BIAS 0.5
in vec4 at_midBlock;
    #include "/lib/lpv/blocks.glsl"
    #include "/lib/lpv/entities.glsl"
    #include "/lib/lpv/voxel_common.glsl"
    #include "/lib/lpv/voxel_write.glsl"
#endif

#if defined DISTANT_HORIZONS && !defined SHADOW_DEBUG

vec3 mul3(const in mat4 matrix, const in vec3 vector)
{
    return mat3(matrix) * vector + matrix[3].xyz;
}
#endif
void main()
{
    lmtexcoord.xy = gl_MultiTexCoord0.xy;
#if SHADOW_FILTERING == 2
    color = gl_Color;
#endif
#ifdef LPV_ENABLED
    PopulateShadowVoxel(mat3(shadowModelViewInverse) * (mat3(gl_ModelViewMatrix) * vec3(gl_Vertex) + gl_ModelViewMatrix[3].xyz) + shadowModelViewInverse[3].xyz);
#endif

    vec4 position = gl_ModelViewProjectionMatrix * gl_Vertex;
    isflower = 0;
    isflower = float((int(mc_Entity.x) == 2001) || (int(mc_Entity.x) == 2011) || (int(mc_Entity.x) == 2004) || (int(mc_Entity.x) == 2002));

#ifdef SHADOW_WAVE
    bool Flower = isFlower(int(mc_Entity.x), (gl_MultiTexCoord0.t < mc_midTexCoord.t));
    bool Leaves = isLeaves(int(mc_Entity.x), (abs(position.z) < 128.0 && gl_MultiTexCoord1.y > 100.0));
    vec4 temp = gl_Vertex;
    vec4 temp2 = gl_MultiTexCoord1;
    if (Flower || Leaves)
    {
        position.xyz = toClipSpace3_shadow(computeWaveOffsetShadow(position.xyz, cameraPosition, temp, temp2, gbufferModelView)).xyz;
    }
#endif

    position.xy = calcShadowDistortion(position.xyz);
    position.z *= 0.1666666666666667;

#if defined DISTANT_HORIZONS && !defined SHADOW_DEBUG

         position.z += 0.0001;

    vec3 shadowViewPos = mul3(gl_ModelViewMatrix, gl_Vertex.xyz);
    viewVector = mul3(shadowModelViewInverse, shadowViewPos);
#endif

    gl_Position = position;
}
