#version 140 compatibility

#extension GL_ARB_explicit_attrib_location : enable
#extension GL_ARB_shader_image_load_store : enable

#include "/includes/main.glsl"





varying vec4 color;
varying vec2 lmtexcoord;
varying vec3 viewVector;

#ifdef LPV_ENABLED
#define SHADOW_MAP_BIAS 0.5


attribute vec4 mc_midTexCoord;
attribute vec4 mc_Entity;


#include "/lib/lpv/blocks.glsl"
#include "/lib/lpv/entities.glsl"

#ifdef IRIS_FEATURE_BLOCK_EMISSION_ATTRIBUTE
attribute vec4 at_midBlock;
#else
attribute vec3 at_midBlock;
#endif

#include "/lib/lpv/voxel_common.glsl"
#include "/lib/lpv/voxel_write.glsl"
#endif

vec3 mul3(const in mat4 matrix, const in vec3 vector)
{
    return mat3(matrix) * vector + matrix[3].xyz;
}

void main()
{
    vec2 light = vec2(gl_MultiTexCoord1.xy * recip);
#ifdef LPV_ENABLED
    PopulateShadowVoxel(mat3(shadowModelViewInverse) * (mat3(gl_ModelViewMatrix) * vec3(gl_Vertex) + gl_ModelViewMatrix[3].xyz) + shadowModelViewInverse[3].xyz);
#endif
    if (light.y > 0.001)
    {
        color = gl_Color;

        vec4 position = gl_ModelViewProjectionMatrix * gl_Vertex;

        position.z *= 0.1666666666666667; // 1/6
        vec2 shadowDistortion = calcShadowDistortion(position.xyz);
        position.xy = shadowDistortion;
        position.z += 0.00007;
        //  position.z += 0.00007;
        vec3 shadowViewPos = mul3(gl_ModelViewMatrix, gl_Vertex.xyz);

        viewVector = mul3(shadowModelViewInverse, shadowViewPos);

        lmtexcoord.xy = gl_MultiTexCoord0.xy;

        gl_Position = position;
    }
    else
    {
        gl_Position.xyzw = vec4(0.0, 0.0, 1e30, 0.0); // Degenerates the triangle
    }
}
