#version 140 compatibility
#extension GL_EXT_gpu_shader4 : enable
#include "/includes/main.glsl"

varying vec4 color;
varying vec2 lmtexcoord;
varying vec3 viewVector;








float GetBorderFogMixFactor(in vec3 eyePlayerPos, in float far)
{

    float eyeDist = length(eyePlayerPos);
    float borderFogFactor = smoothstep(far * 0.75, far, eyeDist);
    borderFogFactor *= borderFogFactor * borderFogFactor;
    return (eyeDist > far * 0.75) ? borderFogFactor : 0.0;
}
void main()
{
    /* DRAWBUFFERS:0*/

#if defined DISTANT_HORIZONS

    float factor = GetBorderFogMixFactor(viewVector, far);

    float noise = noise_standard(gl_FragCoord.xy);

    if (factor > noise)
    {
        discard;
    }
#endif

#if SHADOW_FILTERING == 2
    vec4 color = texture(tex, lmtexcoord.xy) * color;

    gl_FragData[0] = color;
#else
    float alpha = texture(tex, lmtexcoord.xy).a;

    gl_FragData[0].a = alpha;
#endif

}
