varying vec2 texcoord;

vec2 reproject2D(vec2 uv)
{
    // reconstruct world‐space point in homogeneous form
    vec4 p = gbufferModelViewInverse * (gbufferProjectionInverse * vec4(uv * 2.0 - 1.0, 1.0, 1.0));
    // dehomogenize, apply camera offset, re‑homogenize
    p.xyz = p.xyz / p.w + (cameraPosition - previousCameraPosition);
    p.w = 1.0;
    // project through previous view and projection
    p = gbufferPreviousProjection * (gbufferPreviousModelView * p);
    // back to [0,1]
    return p.xy / p.w * 0.5 + 0.5;
}

/* DRAWBUFFERS:8 */
void main()
{
// compile‑time inverse cloud scale
#if CLOUD_QUALITY == 3
    const float invCloudC = 1.0;
#elif CLOUD_QUALITY == 2
    const float invCloudC = 1.3333333; // = 1/0.75
#else // CLOUD_QUALITY == 1
    const float invCloudC = 2.0; // = 1/0.5
#endif

    // fetch last‑frame sky
    vec2 prevUV = reproject2D(texcoord);
    vec4 skySample = texture(colortex8, prevUV);
    float alpha = clamp(skySample.a, 0.0, 1.0);

    // reconstruct view‑space direction
    vec2 offs = texelSize * invCloudC * gl_FragCoord.xy;
    vec3 scrPos = toScreenSpace(vec3(offs, gl_FragCoord.z));
    vec3 viewDir = normalize(mat3(gbufferModelViewInverse) * scrPos);

    // shade and output
    vec3 rgb = skyFromTex2(viewDir, gaux3).rgb;
    gl_FragData[0] = vec4(rgb, alpha);
}
