varying vec3 np3;
varying vec4 color;

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, (m)[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

void main()
{
    const float skysize[3] = float[](1.0, 0.5, 0.75);
    color = gl_Color;

    vec4 mv = gl_ModelViewMatrix * gl_Vertex;
    np3 = viewToWorld(mv.xyz);

    gl_Position = taaFunc(toClipSpace4(mv.xyz));

#ifdef IS_IRIS
    float scale = skysize[CLOUD_QUALITY];
    gl_Position.xy = scale * gl_Position.xy + (scale - 1.0) * gl_Position.w;
#endif
}
