varying vec3 np3;
varying vec4 color;

/* DRAWBUFFERS:8 */
void main()
{
    vec3 fragpos = toScreenSpace(gl_FragCoord.xyz * vec3(texelSize / 0.75, 1.0));
    vec3 p3 = toWorldSpace(fragpos);
    vec3 normp3 = normalize(p3);

    vec4 albedo = vec4(skyFromTex2(normp3, gaux3).rgb, 1.0);

    if (renderStage == MC_RENDER_STAGE_STARS)
        albedo = vec4(1.0); // Override for stars

    gl_FragData[0] = albedo;
}
