

#define WATER_PROG
#define WAVY_STRENGTH 1.0 //[0.1 0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0]
#define WAVY_SPEED 0.0025 //[0.001 0.01 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 1.0 1.25 1.5 2.0 3.0 4.0]

flat varying vec4 labvalue;
varying vec3 p3;

varying mat3 tbnMatrix;
varying vec4 color;
flat varying float iswater;
varying vec4 lmtexcoord;
varying vec3 torch;
varying vec3 viewVector;
varying vec3 normal0;
varying vec3 normal1;

attribute vec4 at_tangent;
attribute vec4 mc_Entity;

#include "/lib/sky_function.glsl"

const vec3 torchColor = vec3(3.000, 1.382, 0.408);

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

vec4 getMaterialProperties(int materialIndex)
{
    // Reflectance, Smoothness, Subsurface amounts, and Porosity
    switch (materialIndex)
    {
    case 8: // water
        return vec4(0.02, 0.9, 0.0, 0.0);
    case 50: // glass
    case 51: // glass
    case 52: // glass
    case 53: // glass
    case 54: // glass
    case 55: // glass
    case 56: // glass
    case 57: // glass
    case 58: // glass
    case 59: // glass
    case 60: // glass
    case 61: // glass
    case 62: // glass
    case 63: // glass
    case 64: // glass
    case 65: // glass
    case 66: // glass
        return vec4(0.04, 0.95, 0.0, 0.0);
    case 67: // honey
        return vec4(0.04, 0.5, 0.5, 0.0);
    case 68: // ice
        return vec4(0.02, 0.9, 0.5, 0.0);
    case 69: // slime
        return vec4(0.03, 0.9, 0.5, 0.0);
    default:
        return vec4(0.0, 0.0, 0.0, 0.0);
        // Default value if index is out of range
    }
}
#ifdef PHYSICS_MOD
/////////////////////////////////////////
const int PHYSICS_ITERATIONS_OFFSET = 13;
const float PHYSICS_DRAG_MULT = 0.048;
const float PHYSICS_XZ_SCALE = 0.035;
const float PHYSICS_TIME_MULTIPLICATOR = 0.45;
const float PHYSICS_W_DETAIL = 0.75;
const float PHYSICS_FREQUENCY = 6.0;
const float PHYSICS_SPEED = 2.0;
const float PHYSICS_WEIGHT = 0.8;
const float PHYSICS_FREQUENCY_MULT = 1.18;
const float PHYSICS_SPEED_MULT = 1.07;
const float PHYSICS_ITER_INC = 12.0;
const float PHYSICS_NORMAL_STRENGTH = 1.4;
/////////////////////////////////////////
uniform int physics_iterationsNormal;
uniform vec2 physics_waveOffset;
uniform ivec2 physics_textureOffset;
uniform float physics_gameTime;
uniform float physics_oceanHeight;
uniform sampler2D physics_waviness;
uniform float physics_oceanWaveHorizontalScale;
uniform vec3 physics_modelOffset;
uniform float physics_rippleRange;
uniform float physics_foamAmount;
uniform float physics_foamOpacity;
uniform sampler2D physics_ripples;
uniform sampler3D physics_foam;
uniform sampler2D physics_lightmap;

uniform float physics_globalTime;

float physics_waveHeight(vec2 position, int iterations, float factor, float time)
{
    position = (position - physics_waveOffset) * PHYSICS_XZ_SCALE * physics_oceanWaveHorizontalScale;
    float iter = 0.0;
    float frequency = PHYSICS_FREQUENCY;
    float speed = PHYSICS_SPEED;
    float weight = 1.0;
    float height = 0.0;
    float waveSum = 0.0;
    float modifiedTime = time * PHYSICS_TIME_MULTIPLICATOR;

    for (int i = 0; i < iterations; i++)
    {
        vec2 direction = vec2(sin(iter), cos(iter));
        float x = dot(direction, position) * frequency + modifiedTime * speed;
        float wave = exp(sin(x) - 1.0);
        float result = wave * cos(x);
        vec2 force = result * weight * direction;

        position -= force * PHYSICS_DRAG_MULT;
        height += wave * weight;
        iter += PHYSICS_ITER_INC;
        waveSum += weight;
        weight *= PHYSICS_WEIGHT;
        frequency *= PHYSICS_FREQUENCY_MULT;
        speed *= PHYSICS_SPEED_MULT;
    }

    return height / waveSum * physics_oceanHeight * factor - physics_oceanHeight * factor * 0.5;
}

vec2 physics_waveDirection(vec2 position, int iterations, float time)
{
    position = (position - physics_waveOffset) * PHYSICS_XZ_SCALE * physics_oceanWaveHorizontalScale;
    float iter = 0.0;
    float frequency = PHYSICS_FREQUENCY;
    float speed = PHYSICS_SPEED;
    float weight = 1.0;
    float waveSum = 0.0;
    float modifiedTime = time * PHYSICS_TIME_MULTIPLICATOR;
    vec2 dx = vec2(0.0);

    for (int i = 0; i < iterations; i++)
    {
        vec2 direction = vec2(sin(iter), cos(iter));
        float x = dot(direction, position) * frequency + modifiedTime * speed;
        float wave = exp(sin(x) - 1.0);
        float result = wave * cos(x);
        vec2 force = result * weight * direction;

        dx += force / pow(weight, PHYSICS_W_DETAIL);
        position -= force * PHYSICS_DRAG_MULT;
        iter += PHYSICS_ITER_INC;
        waveSum += weight;
        weight *= PHYSICS_WEIGHT;
        frequency *= PHYSICS_FREQUENCY_MULT;
        speed *= PHYSICS_SPEED_MULT;
    }

    return vec2(dx / pow(waveSum, 1.0 - PHYSICS_W_DETAIL));
}

vec3 physics_waveNormal(const in vec2 position, const in vec2 direction, const in float factor, const in float time)
{
    float oceanHeightFactor = physics_oceanHeight / 13.0;
    float totalFactor = oceanHeightFactor * factor;
    vec3 waveNormal = normalize(vec3(direction.x * totalFactor, PHYSICS_NORMAL_STRENGTH, direction.y * totalFactor));

    vec2 eyePosition = position + physics_modelOffset.xz;
    vec2 rippleFetch = (eyePosition + vec2(physics_rippleRange)) / (physics_rippleRange * 2.0);
    vec2 rippleTexelSize = vec2(2.0 / textureSize(physics_ripples, 0).x, 0.0);
    float left = texture(physics_ripples, rippleFetch - rippleTexelSize.xy).r;
    float right = texture(physics_ripples, rippleFetch + rippleTexelSize.xy).r;
    float top = texture(physics_ripples, rippleFetch - rippleTexelSize.yx).r;
    float bottom = texture(physics_ripples, rippleFetch + rippleTexelSize.yx).r;
    float totalEffect = left + right + top + bottom;

    float normalx = left - right;
    float normalz = top - bottom;
    vec3 rippleNormal = normalize(vec3(normalx, 1.0, normalz));
    return normalize(mix(waveNormal, rippleNormal, pow(totalEffect, 0.5)));
}

struct WavePixelData
{
    vec2 direction;
    vec2 worldPos;
    vec3 normal;
    float foam;
    float height;
};

varying vec3 physics_localPosition;
varying vec3 physics_foamColor;
varying float physics_localWaviness;

#endif
void main()
{
    bool tangentValid = dot(at_tangent.xyz, at_tangent.xyz) > 1e-9; // TODO: Get at_tangent fixed so this isn't needed
    tbnMatrix[0] =
        mat3(gbufferModelViewInverse) * (tangentValid ? normalize(gl_NormalMatrix * at_tangent.xyz) : vec3(0.0));
    tbnMatrix[2] = mat3(gbufferModelViewInverse) * (normalize(gl_NormalMatrix * gl_Normal));
    tbnMatrix[1] = cross(tbnMatrix[0], tbnMatrix[2]) * (at_tangent.w < 0.0 ? -1.0 : 1.0);

    lmtexcoord.xy = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;
    float mat = 0.0;

    if (int(mc_Entity.x) >= 50 && int(mc_Entity.x) <= 66)
        mat = 0.01;
    if (int(mc_Entity.x) >= 67 && int(mc_Entity.x) <= 70)
        mat = 0.1;

    switch (int(mc_Entity.x))
    {
    case 8:
        mat = 1;
        break;
    case 9:
        mat = 0.8;
        break;
    case 1:
        mat = 0.7;
        break;
    case 68:
        mat = 0.8;
        break;
    case 20002:
        mat = 0.01;
        break;
    default:
        break;
    }

    labvalue = vec4(0);
    int entityCheck = int(mc_Entity.x);

    labvalue = getMaterialProperties(entityCheck);

    viewVector = (gl_ModelViewMatrix * gl_Vertex).xyz;
    p3 = gl_Vertex.xyz;

    color = gl_Color;

    normal0 = gl_NormalMatrix * gl_Normal;
    normal1 = gl_Normal;
    const float lightmapMin = 8.0;
    const float lightmapMax = 238.0;
    vec2 lmNorm = clamp((gl_MultiTexCoord1.xy - lightmapMin) / (lightmapMax - lightmapMin), 0.0, 1.0);

    lmtexcoord.zw = pow(lmNorm, vec2(2.0));
    iswater = mat;
    float lmx = gl_MultiTexCoord1.x * recip;
    torch = vec3(3.000, 1.382, 0.408);

    // Apply lightmap power
    float lightmapPow = pow(lmx, 4.0);
    torch *= lightmapPow + lmx * 0.025;

    torch = clamp(torch, 0.0, 4.0) * 2.0;
    if (entityCheck == 164)
        torch *= 4.0;

#ifndef PHYSICS_MOD
    vec3 position = mat3(gl_ModelViewMatrix) * gl_Vertex.xyz + gl_ModelViewMatrix[3].xyz;

    gl_Position = taaFunc(toClipSpace4(position));
#else

    physics_foamColor = textureLod(physics_lightmap, (mat4(vec4(0.00390625, 0.0, 0.0, 0.0), vec4(0.0, 0.00390625, 0.0, 0.0), vec4(0.0, 0.0, 0.00390625, 0.0), vec4(0.03125, 0.03125, 0.03125, 1.0)) * gl_MultiTexCoord1).xy, 0).rgb;
    physics_localWaviness = texelFetch(physics_waviness, ivec2(gl_Vertex.xz) - physics_textureOffset, 0).r;
    vec4 physics_finalPosition = vec4(gl_Vertex.x, gl_Vertex.y + physics_waveHeight(gl_Vertex.xz, PHYSICS_ITERATIONS_OFFSET, physics_localWaviness, physics_gameTime), gl_Vertex.z, gl_Vertex.w);

    physics_localPosition = physics_finalPosition.xyz;
    vec4 position2 = gbufferModelViewInverse * gl_ModelViewMatrix * physics_finalPosition;
    gl_Position = gl_ProjectionMatrix * gbufferModelView * position2;
#endif
    // gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
}
