

#define SIMPLEFOG
#define WATERSTAGE

varying mat3 tbnMatrix;
varying vec4 color;
flat varying float iswater;
varying vec4 lmtexcoord;
varying vec3 torch;
varying vec3 viewVector;
varying vec3 p3;
varying vec3 normal0;
varying vec3 normal1;
flat varying vec4 labvalue;

#ifdef PHYSICS_MOD
    #include "/lib/physicsmod.glsl"

#endif

#include "/lib/sky_function.glsl"
#include "/lib/light.glsl"

vec2 tapLocation(int sampleNumber, int nb, float nbRot, float jitter, float distort)
{
    float alpha = (sampleNumber + jitter) / nb;
    float angle = jitter * TWO_PI + alpha * nbRot * TWO_PI;

    float sin_v, cos_v;

    sin_v = sin(angle);
    cos_v = cos(angle);

    return vec2(cos_v, sin_v) * sqrt(alpha);
}
#ifdef WATER_SHADOWS

const vec2 shadowOffsets[6] = vec2[6](vec2(0.5303, 0.5303), vec2(-0.6250, -0.0000), vec2(0.3536, -0.3536),
                                      vec2(-0.0000, 0.3750), vec2(-0.1768, -0.1768), vec2(0.1250, 0.0000));

#endif
#define viewMAD(m, v) (mat3(m) * (v) + (m)[3].xyz)

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

#include "/lib/water/waterfuncs2.glsl"

#ifdef WATER_PBR
    #if SSR_QUALITY == 0
        #include "/lib/water/ssr_normal.glsl"
    #elif SSR_QUALITY == 1
        #include "/lib/water/ssr_extra_low.glsl"

    #elif SSR_QUALITY == 2
        #include "/lib/water/ssr_low.glsl"
    #else
        #include "/lib/water/ssr_hq.glsl"

    #endif
#else
    #include "/lib/water/ssr_normal.glsl"
#endif

float GetBorderFogMixFactorCylinder(in vec3 eyePlayerPos, in float far, bool isWater)
{

    float mixval = 0.75;

    if (isWater)
        mixval = 0.33;
    float eyeDist = length(eyePlayerPos.xz);
    float borderFogFactor = smoothstep(far * mixval, far, eyeDist);

    return borderFogFactor;
}

vec4 getSpecularProperties(vec2 tcoord)
{
    float reflectance = labvalue.x;
    float smoothness = labvalue.y;
    float sss = labvalue.z;
    float emissives = 0;
#ifdef LAB_PBR
    if (iswater < 0.99)
    {

        // vec4 specularTex = texture2DLod(specular, tcoord, 0);
        vec4 specularTex = texture(specular, tcoord);

        smoothness = specularTex.x;
        sss = specularTex.z;
        reflectance = specularTex.y;
        emissives = specularTex.w;
    }
#endif
    return vec4(sss, emissives, reflectance, smoothness);
}

vec2 computeRefractedCoord(
    vec3 fragPos0,
    vec3 fragPos1,
    vec2 texcoord,
    vec3 normalFlat,
    vec3 normal)
{
    vec3 I = normalize(fragPos0); // view vector from fragment to eye

    // Determine the refraction index based on whether the eye is underwater
    float eta = (isEyeInWater == 0) ? (1.0 / 1.33) : 1.33; // assuming water IOR = 1.33

    float NoI = dot(normal, I);
    float eta2 = eta * eta;
    float NoI2 = NoI * NoI;
    float k = 1.0 - eta2 * (1.0 - NoI2);

    if (k < 0.0)
    {
        return vec2(0.0);
    }

    float sqrtK = sqrt(k);

    vec3 normFlatDiff = (normalFlat - normal);
#ifdef PHYSICS_MOD
    normFlatDiff *= 8.0;
#endif

    vec3 refractedDir = eta * (dot(normalFlat, I) * normalFlat - NoI * normal) + sqrtK * normFlatDiff + eta * I;

    vec3 refractedPos = fragPos0 + normalize(refractedDir) * distance(fragPos0, fragPos1);

    vec3 screenPos = toClipSpace3(refractedPos);

    return screenPos.xy - texcoord;
}

////
float phaseg(float x, float g)
{
    float gg = g * g;
    return (gg * -0.25 + 0.25) * pow(-2.0 * (g * x) + (gg + 1.0), -1.5) / PI;
}

#include "/lib/fog/fognoloop.glsl"

mat3 tbn_from_world_normal(vec3 N)
{
    // Normalize the input normal just to be safe
    N = normalize(N);

    // Choose an arbitrary vector that is not parallel to the normal
    vec3 arbitrary = abs(N.y) < 0.999 ? vec3(0.0, 1.0, 0.0) : vec3(1.0, 0.0, 0.0);

    // Compute the tangent vector as a vector orthogonal to the normal
    vec3 T = normalize(cross(arbitrary, N));

    // Compute the bitangent as the cross product of the normal and the tangent
    vec3 B = cross(N, T); // No need to normalize, it is already orthogonal

    // Construct and return the TBN matrix
    return mat3(T, B, N);
}
/*RENDERTARGETS: 1,5,13*/

// --- Feature Toggles ---

// Toggle features by commenting/uncommenting the following defines:
#define USE_PREVIOUS_FRAME_MASK      // Uses the previous frame's mask for glass water detection.
#define ENABLE_REFLECTIONS           // Toggles the reflections pass.
#define ENABLE_WATER_SPECIAL_NORMALS // Use custom water normals instead of a texture lookup.
#define ENABLE_WATER_FOG             // Enable water fog / underwater eye effects.
#define ENABLE_WATER_SHADOWS         // Enable water shadow calculations.
#define ENABLE_RAIN_EFFECTS          // Apply rain effects to light calculations.
#define ENABLE_AMBIENT_LIGHTING      // Compute ambient lighting.
#define ENABLE_WATER_FOAM            // Blend in water foam (requires PHYSICS_MOD).

void main()
{
    // --- PHYSICS MOD ---
#ifdef PHYSICS_MOD
    physics_waveData = physics_wavePixel(physics_localPosition.xz, physics_localWaviness, physics_iterationsNormal, physics_gameTime);
    vec3 physics_normal = normalize(gl_NormalMatrix * physics_waveData.normal);
#endif

    // --- Water Mask and Debug Data ---
    bool waterMask = (iswater > 0.99);
    gl_FragData[1] = waterMask ? vec4(1, 0, 0, 0.95) : vec4(0, 0, 1, 0.1);

    // --- Initial Setup ---
    const vec3 wcolor = vec3(0.18, 0.35, 0.43);
    vec2 texc = gl_FragCoord.xy * texelSize;
    vec2 texcoord = lmtexcoord.xy;

    // --- Previous Frame Mask ---
#ifdef USE_PREVIOUS_FRAME_MASK
    vec3 prevtexc = Reproject(vec3(texc, gl_FragCoord.z));
    float mask = texture(colortex4, prevtexc.xy).a;
    bool isGlassWater = mask > 0.9;
#else
    bool isGlassWater = false;
#endif

    vec4 materialProps = getSpecularProperties(texcoord);
    float f0 = materialProps.z;
    vec4 outcolor;
    vec3 fragpos = viewVector;

    // --- Normals Initialization ---
    vec3 normFragpos = normalize(fragpos);
    vec3 normal = normal1;
    vec3 normalWorld = normal0;
    vec3 normalTex = vec3(0.0);

#ifdef LAB_PBR
    normalTex = texture(normals, texcoord).rgb;
    normal = normalize(tbnMatrix * (normalTex * 2.0 - 1.0));
    normalWorld = worldToView(normal);
#endif

    // --- DISTANT HORIZONS Check ---
#if defined DISTANT_HORIZONS
    vec2 uv = gl_FragCoord.xy * texelSize;
    float waterMaskDH = texture2D(colortex5, uv).r;
    float sceneDepth = texture2D(depthtex1, uv).x;
    float viewDistance = length(p3);
    float farClip = far - 64.0; // 16 * 4 = 64

    bool isDistantWater = waterMaskDH > 0.0 && viewDistance > farClip && sceneDepth >= 1.0;
    if (isDistantWater)
    {
        discard;
    }
#endif

    // --- Water Surface Normals ---
    if (waterMask)
    {
        vec3 posxz = p3 + cameraPosition;
#ifdef ENABLE_WATER_SPECIAL_NORMALS
        normalTex = waterNormal(posxz.xz - posxz.y, normFragpos);
#else
        normalTex = texture(normals, texcoord).rgb;
#endif
#ifdef DISTANT_HORIZONS
        mat3 TBNUP = tbn_from_world_normal(normal1);
        normal = normalize(TBNUP * (normalTex * 2.0 - 1.0));
#else
        normal = normalize(tbnMatrix * (normalTex * 2.0 - 1.0));
#endif
        normalWorld = worldToView(normal);
    }

#ifdef PHYSICS_MOD
    normal = mix(viewToWorld(physics_normal), normal, 0.1);
    normalWorld = mix(physics_normal, normalWorld, 0.1);
#endif

    // --- Compute Refraction (if enabled) ---
#ifdef REFRACTION
    vec2 refractionMain = computeRefractedCoord(
        fragpos,
        toScreenSpace(vec3(texc, texture(depthtex1, texc).x)),
        texc,
        normal0,
        normalWorld);
#endif

    // --- Texture and Albedo Processing ---
    vec4 albedo = texture2D(texture, texcoord);
    albedo.rgb = toLinear(albedo.rgb * color.rgb);

#ifndef VANILLA_WATER
    outcolor = waterMask ? vec4(toLinear(mix(wcolor, color.rgb, 0.25)), 0.5) : albedo;
    #ifdef DISTANT_HORIZONS
    outcolor = waterMask ? vec4(mix(toLinear(wcolor), pow(color.rgb / color.a, vec3(2.0)), 0.25), 0.5) : albedo;
    #endif
#else
    outcolor = waterMask ? vec4(albedo.rgb, 0.5) : albedo;
#endif

    float alpha0 = waterMask ? 0.1 : outcolor.a;

#ifdef REFRACTION
    gl_FragData[2] = vec4(refractionMain, 0.0, outcolor.a);
#endif

    gl_FragData[3] = outcolor;

    // --- Lighting Calculation ---
    float diffuseSun = max(dot(normal, lightPos), 0.0) * lmtexcoord.w;
    vec3 direct = sunLight;
    float shading = 1.0;

#ifdef OVERWORLD
    #ifdef ENABLE_WATER_SHADOWS
    if (diffuseSun > 0.0)
    {
        float noise = R2_dither(gl_FragCoord.xy);

        vec3 ProjShadowPos = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
        ProjShadowPos = diagonal3(shadowProjection) * ProjShadowPos + shadowProjection[3].xyz;

        float distortFactor = calcDistort(ProjShadowPos.xy);
        ProjShadowPos.xy *= distortFactor;

        if (all(lessThan(abs(ProjShadowPos.xy), (vec2(1.0, 1.0) - 1.5 / shadowMapResolution))) &&
            abs(ProjShadowPos.z) < 6)
        {
            float threshMulMult = mix(2048, 4096, float(eyeAltitude > 400));
            float threshMulMult2 = mix(threshMulMult, 8192, float(eyeAltitude > 500));
            float threshMul = max(threshMulMult2 / shadowMapResolution * shadowDistance / 100.0, 0.95);
            float distortThresh = clamp(sqrt(1.0 - diffuseSun * diffuseSun) / diffuseSun, 0.0, 0.25) / distortFactor;
            float diffthresh = distortThresh / 6000.0 * threshMul;

            ProjShadowPos = ProjShadowPos * vec3(0.5, 0.5, 0.5 / 6.0) + 0.5;

            shading = 0.0;
            float rdMul = 4.0 / shadowMapResolution;
            for (int i = 0; i < 9; i++)
            {
                vec2 offsetS = tapLocation(i, 9, 2.0, noise, 0.0);
                float weight = 1.0 + (i + noise) * rdMul / 9.0 * shadowMapResolution;
                vec3 shadowCoordWeighted = vec3(ProjShadowPos + vec3(rdMul * offsetS, -diffthresh * weight));
                float shadow0 = texture(shadowtex1, shadowCoordWeighted);
        #ifdef COLORED_SHADOWS
                float shadow1 = texture(shadow, shadowCoordWeighted);
                float transparentshadow = distance(shadow1, shadow0);
                vec4 shadowcolor = texture(shadowcolor0, shadowCoordWeighted.xy);
                if (transparentshadow > 0)
                {
                    shading += clamp(shadow1 + clamp((1 - shadowcolor.a), 0.0, 1.0), 0.0, 1.0) / 9.0;
                }
                else
                {
                    shading += shadow1 / 9.0;
                }
        #else
                shading += shadow0 / 9.0;
        #endif
            }
        }
        shading = mix(0.0, shading, shadowblend);
        diffuseSun = min(shading, diffuseSun) * lmtexcoord.w;
        direct *= shading;
    }
    #endif
#endif

#ifdef ENABLE_RAIN_EFFECTS
    direct *= (1 - rainStrength * 0.9);
    diffuseSun *= (1 - rainStrength * 0.9);
#endif

#ifdef ENABLE_AMBIENT_LIGHTING
    vec3 ambient = calcAmbientLight(normal, lmtexcoord.zw, atmosphereUp, diffuseSun, torch);
#else
    vec3 ambient = vec3(0.0);
#endif

    outcolor.rgb += (materialProps.y * 8.0 * outcolor.rgb * outcolor.rgb);
    if (!waterMask)
    {
        ambient *= color.a;
    }

    vec3 diffuse = ambient * outcolor.rgb * diffuseSun;
    vec3 transmission = ambient * outcolor.rgb;
    outcolor.rgb = mix(transmission, diffuse, outcolor.a * outcolor.a);

#ifdef ENABLE_REFLECTIONS
    outcolor = reflections(lmtexcoord.w, normal, fragpos, materialProps, outcolor, diffuseSun, albedo.rgb, alpha0);
#endif

#ifdef ENABLE_WATER_FOG
    if ((!waterMask && isGlassWater) || (isEyeInWater == 1))
    {
        float estEyeDark = clamp(eyeBrightnessSmooth.y / 255.0, 0.0, 1.0);
        float estEyeDepth = clamp((14.0 - (eyeBrightnessSmooth.y / 255.0 * 16.0)) / 14.0, 0.0, 1.0);
        estEyeDepth = pow(estEyeDepth, 3.0) * 8.0;

        float rayLength = length(fragpos);
        float maxZ = min(rayLength, 32.0) / (1e-8 + rayLength);
        rayLength *= maxZ;

        vec3 absorbance_w1 = vec3(1.0);
        vec3 vL_w1 = vec3(0.0);
        waterBasic(rayLength, p3, estEyeDepth, atmosphereUp, sunLight, absorbance_w1, vL_w1, p3, p3);

        if (isEyeInWater == 0)
            vL_w1 *= estEyeDark;
        outcolor.rgb *= absorbance_w1;
        outcolor.rgb += vL_w1;
    }
#endif

    if (waterMask && !(normal1.g < -0.1) && isEyeInWater == 1)
    {
        gl_FragData[1] = vec4(0, 0, 0, 0.0);
        outcolor.a = 0;
#ifdef REFRACTION
        gl_FragData[2].a = 0;
#endif
    }

#ifdef PHYSICS_MOD
    #ifdef ENABLE_WATER_FOAM
    outcolor = mix(outcolor, vec4(physics_foamColor * diffuseSun, 1.0), physics_waveData.foam);
    #endif
#endif

    // outcolor = vec4(vec3(BlendFactor), 1);
    gl_FragData[0] = clamp(outcolor, 0, 1000);
}
