



varying vec4 color;
varying float NdotL;
flat varying vec3 torch;
varying vec2 texcoord;


#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)









const vec3 torchColor = vec3(3.000, 1.382, 0.408);

void main()
{
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;
    color = gl_Color;

#ifdef COMPLEX_NORMALS
    vec3 normal = viewToWorld(normalize(gl_NormalMatrix * gl_Normal));
#else
    vec3 normal = gl_Normal;
#endif
    torch = (pow(gl_MultiTexCoord1.x * recip, 3.0) * 0.5) * torchColor * 3.0;

    NdotL = clamp(dot(normal, sunVec), 0.0, 1.0);

    vec3 position = mat3(gl_ModelViewMatrix) * vec3(gl_Vertex) + gl_ModelViewMatrix[3].xyz;
    gl_Position =  taaFunc(toClipSpace4(position));
}
