

varying vec4 color;
varying float skylight;

flat varying vec3 torch;
varying vec2 texcoord;
//#define PARTICLE_SHADOWS

#include "/lib/shadows/shadowfunc_simplest.glsl"

vec3 calcAmbientLight(float diffuseSun, vec3 torch, float alpha, float shadow)
{

    float mixstrength = clamp(pow(shadowblend, 0.3), 0.0, 1.0);
    float oneMinusMixStrength = 1.0 - mixstrength;

    // Precompute factors to minimize operations

    float bounceFactor = (0.15 * diffuseSun) * oneMinusMixStrength + 0.25;
    vec3 bounce = sunLight * bounceFactor * skylight;

    // Combine ambient light components
    vec3 ambientCombined = atmosphereUp * skylight;

    // Mix ambientCombined with bounce lighting
    ambientCombined = ambientCombined * 0.9 + bounce * 0.1;

    // Calculate diffuse lighting
    vec3 diffuseLight = mix(1.0, diffuseSun, alpha * 0.5) * shadow * sunLight + ambientCombined;

    // Compute darkness factors
    float darknessFactor = darknessLightFactor * darknessLightFactor * darknessLightFactor;
    diffuseLight *= (1.0 - 6.0 * darknessFactor);

    // Prepare torch and small light contributions
    vec3 torchContribution = torch * hdrMulttorch;
    float screenBrightnessTerm = 1.0 + screenBrightness * MIN_LIGHT_BOOST;
    vec3 smallLightContribution = vec3(0.002, 0.005, 0.006) * screenBrightnessTerm;

    // Sum up the light components and apply final adjustments
    vec3 light = max(diffuseLight + torchContribution + smallLightContribution, 0.001);
    light *= 1.0 - darknessLightFactor;

    return light;
}

vec3 approximateNormal(vec3 fragPos)
{

    // Calculate tangent vectors
    vec3 dx = dFdx(fragPos);
    vec3 dy = dFdy(fragPos);

    // Compute the normal using the cross product
    vec3 normal = normalize(cross(dx, dy));

    return normal;
}

/* DRAWBUFFERS:1*/
void main()
{
    float shadows = 1.0;
    vec3 fragpos = toScreenSpace(gl_FragCoord.xyz * vec3(texelSize, 1.0));

    vec3 normal = viewToWorld(approximateNormal(fragpos));

    float NdotL = clamp(dot(normal, sunVec), 0.0, 1.0);

    vec4 color = texture(texture, texcoord.xy) * color;
#ifdef PARTICLE_SHADOWS
    vec3 p3 = toWorldSpace(fragpos);
    shadows = shadowFunc(shadows, p3, color.a);

#endif
    color.rgb = toLinear(color.rgb) * calcAmbientLight(NdotL, torch, color.a, shadows);
    //   color.rgb = vec3(shadows);
    // color.a = 1;
    gl_FragData[0] = color;
}
