



varying vec4 color;
varying float NdotL;
varying vec3 viewVector;
flat varying vec3 torch;
varying vec2 texcoord;


#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)









const vec3 torchColor = vec3(3.000, 1.382, 0.408);

void main()
{

    texcoord.xy = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;
    color = gl_Color;
    viewVector = (gl_ModelViewMatrix * gl_Vertex).xyz;

    vec3 normal = normalize(gl_NormalMatrix * gl_Normal);

    torch = 0.2 * torchColor;

    NdotL = clamp(dot(normal, sunVec) , 0.0, 1.0);
    gl_Position = ftransform();
}
