varying vec3 np3;
varying vec2 texcoord;

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, (m)[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

void main() {
    vec3 viewVector = (gl_ModelViewMatrix * gl_Vertex).xyz;
    np3 = viewToWorld(viewVector);
    texcoord = gl_MultiTexCoord0.xy;

    gl_Position = taaFunc(vec4(projMAD(gl_ProjectionMatrix, viewVector), -viewVector.z));

#ifdef IS_IRIS
    #if CLOUD_QUALITY == 3
        const float skysize = 1.0;
    #elif CLOUD_QUALITY == 2
        const float skysize = 0.75;
    #elif CLOUD_QUALITY == 1
        const float skysize = 0.5;
    #else
        const float skysize = 1.0;
    #endif

    gl_Position.xy = gl_Position.xy * skysize + (skysize - 1.0) * gl_Position.w;
#endif
}
