in vec4 vaColor;
out vec4 color;

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, (m)[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

void main()
{
    color = vaColor;

    // Constant skysize calculation using preprocessor
#if CLOUD_QUALITY == 3
    const float skysize = 1.0;
#elif CLOUD_QUALITY == 2
    const float skysize = 0.75;
#elif CLOUD_QUALITY == 1
    const float skysize = 0.5;
#else
    const float skysize = 1.0; // Default fallback
#endif

    vec4 viewPos = gl_ModelViewMatrix * gl_Vertex;
    vec3 projected = projMAD(gl_ProjectionMatrix, viewPos.xyz);
    gl_Position = taaFunc(vec4(projected, -viewPos.z));

#ifdef IS_IRIS
    gl_Position.xy = gl_Position.xy * skysize + (skysize - 1.0) * gl_Position.w;
#endif
}
