varying vec4 color;

/* DRAWBUFFERS:8 */

void main()
{
    // Early discard for render stages that don't need processing
    if (renderStage != MC_RENDER_STAGE_STARS)
        discard;

#ifdef SKYBOX_SUPPORT
//   discard;
#endif

    vec4 outcolor = color;
    const float skysize = 0.5 + float(CLOUD_QUALITY > 1) * 0.25 + float(CLOUD_QUALITY > 2) * 0.25;

    vec2 uv = gl_FragCoord.xy * texelSize / skysize;

    float cloudAlpha = texture(colortex8, uv).a;
    outcolor.rgb = vec3(color.a) * 0.1 * cloudAlpha;
    gl_FragData[0] = outcolor;
}
