

varying vec4 lmtexcoord;
varying vec4 color;

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

#include "/lib/vertex/main.glsl"

void main()
{
    // Define Transforms

    lmtexcoord = vec4(gl_MultiTexCoord0.xy, gl_MultiTexCoord1.xy * recip);
    color = gl_Color;
    vec4 viewPos = gl_ModelViewMatrix * gl_Vertex;
    gl_Position = taaFunc(vec4(diagonal3(gl_ProjectionMatrix) * viewPos.xyz + gl_ProjectionMatrix[3].xyz, -viewPos.z));
}
