

varying vec4 lmtexcoord;
varying vec4 color;

/* DRAWBUFFERS:1*/

void main()
{

    vec4 albedo = texture(texture, lmtexcoord.xy, 0);
    albedo.rgb = toLinear(albedo.rgb * color.rgb);
    if (luma(albedo.rgb) == 0)
        discard;
#if SSR_QUALITY > 1
    albedo.rgb *= 128.0;
#endif

    gl_FragData[0] = albedo; // Albedo
}
