// Optimized Fragment Shader
varying vec4 lmtexcoord;
varying vec4 color;
varying vec3 normalMat;
flat varying float labvalue;
flat varying float emissive;

/* DRAWBUFFERS:02*/

void main()
{
    vec4 albedo = texture(texture, lmtexcoord.xy, 0);
    albedo.rgb = toLinear(albedo.rgb * color.rgb);

    vec2 lightmap = lmtexcoord.zw;
    vec2 materials1 = vec2(color.a, labvalue);

    lightmap.y = lightmap.y += R2_dither(gl_FragCoord.xy) / 256;
    lightmap.x = lightmap.x + emissive;
#if defined ENTITY
	    albedo.rgb = mix(albedo.rgb, entityColor.rgb, entityColor.a);

    #ifdef NAMETAG_FIX
    if (entityId == 1500)
    {
        albedo.a *= color.a;
        materials1.x = 1.0;
    }
    #endif
#endif

    gl_FragData[0] = albedo; // Albedo

    // Pack normals, clamped lightmap, and materials into the second render target.
    gl_FragData[1].rgba = vec4(encodeNormal(normalMat), encodeVec2(clamp(lightmap, 0.0, 1.0)), encodeVec2(materials1));
}
