// Varyings

#if defined LAB_PBR || defined POM || defined LOD_FIX
varying vec4 v_MidTile; // .xy = midtex, .zw = tileSize
#endif

flat varying vec4 labvalue;
flat varying float emissive;

varying vec4 lmtexcoord;
varying vec4 color;
varying vec2 normalMatCompressed;

#if defined(LAB_PBR) || defined(POM)
varying vec4 tangent;
varying vec3 normalMat2;

    #ifdef POM
varying vec4 vtexcoordam;
varying vec2 vtexcoord;
    #endif
#endif

attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;
attribute vec4 at_tangent;

#define diagonal3(m) vec3(m[0].x, m[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + m[3].xyz)

#include "/lib/vertex/main.glsl"

float computeEmissive(float lmtexcoordZ, int entityCheck)
{
    return (entityCheck >= 100 && entityCheck <= 355) ? pow(lmtexcoordZ, 8.0) : 0.0;
}

#if defined LAB_PBR || defined POM
mat3 computeTBN(vec3 normal)
{
    return computeTBNMatrix(gbufferModelViewInverse, gl_NormalMatrix, at_tangent, gl_Normal);
}
#endif

void main()
{
    const float lightmapMin = 8.0;
    const float lightmapMax = 255.0;
    vec2 lmNorm = clamp((gl_MultiTexCoord1.xy - lightmapMin) / (lightmapMax - lightmapMin), 0.0, 1.0);
    lmtexcoord = vec4(gl_MultiTexCoord0.xy, lmNorm);

    int entityCheck = int(mc_Entity.x);
    labvalue = getMaterialProperties(entityCheck);
    emissive = computeEmissive(lmtexcoord.z, entityCheck);
    color = gl_Color;

#if defined LAB_PBR || defined POM || defined LOD_FIX
    v_MidTile.xy = mc_midTexCoord.st;
    v_MidTile.zw = 2.0 * abs(lmtexcoord.xy - v_MidTile.xy);
#endif

    // Optimize normal calculations - do minimum transforms
    vec3 normalWorld = gl_Normal;
    vec3 normalViewSpace;
    
#if defined(LAB_PBR) || defined(POM) || defined(COMPLEX_NORMALS)
    normalViewSpace = normalize(gl_NormalMatrix * gl_Normal);
    #ifdef COMPLEX_NORMALS
        normalWorld = viewToWorld(normalViewSpace);
    #endif
#endif

    normalMatCompressed = encodeNormal(normalWorld);

#if defined(LAB_PBR) || defined(POM)
    normalMat2 = normalViewSpace;
#endif

#if defined(LAB_PBR) || defined(POM)
    // Compute tangent once
    bool tangentValid = dot(at_tangent.xyz, at_tangent.xyz) > 1e-9;
    vec3 T = tangentValid ? normalize(mat3(gl_NormalMatrix) * at_tangent.xyz) : vec3(0.0);
    tangent = vec4(T, at_tangent.w);
    
    #ifdef POM
        vec2 midcoord = (gl_TextureMatrix[0] * mc_midTexCoord).st;
        vec2 diff = lmtexcoord.xy - midcoord;
        vtexcoordam.pq = abs(diff) * 2.0;
        vtexcoordam.st = min(lmtexcoord.xy, 2.0 * midcoord - lmtexcoord.xy);
        vtexcoord = sign(diff) * 0.5 + 0.5;
    #endif
#endif

    // Compute position once
    vec4 viewPos = gl_ModelViewMatrix * gl_Vertex;
    vec3 pos = viewPos.xyz;

#ifdef LEAVES
    bool Flower = isFlower(entityCheck, (gl_MultiTexCoord0.t < mc_midTexCoord.t));
    bool LeavesFlag = isLeaves(entityCheck, (abs(pos.z) < 128.0 && gl_MultiTexCoord1.y > 100.0));
    if (Flower || LeavesFlag)
    {
        pos = computeWaveOffset(pos, cameraPosition, gl_Vertex, gl_MultiTexCoord1, gbufferModelView);
        viewPos.xyz = pos;
    }
#endif

    // Single projection calculation
    vec4 clipPos = vec4(diagonal3(gl_ProjectionMatrix) * pos + gl_ProjectionMatrix[3].xyz, -viewPos.z);
    
#if defined ENTITY && defined NO_ENTITY_TAA
    gl_Position = clipPos;
#else
    gl_Position = taaFunc(clipPos);
#endif
}