

#define SIMPLEFOG
#define WATERSTAGE

varying vec4 color;
varying float iswater;
varying vec4 lmtexcoord;
varying vec3 torch;
varying vec3 viewVector;
varying vec3 normal0;
varying vec3 normal1;
flat varying vec4 labvalue;
varying vec3 p3;

#ifdef PHYSICS_MOD
    #include "/lib/physicsmod.glsl"

#endif

#include "/lib/sky_function.glsl"
#include "/lib/light.glsl"
#ifdef WATER_SHADOWS

const vec2 shadowOffsets[6] = vec2[6](vec2(0.5303, 0.5303), vec2(-0.6250, -0.0000), vec2(0.3536, -0.3536),
                                      vec2(-0.0000, 0.3750), vec2(-0.1768, -0.1768), vec2(0.1250, 0.0000));

vec2 tapLocation(int sampleNumber, int nb, float nbRot, float jitter, float distort)
{
    float alpha = (sampleNumber + jitter) / nb;
    float angle = jitter * TWO_PI + alpha * nbRot * TWO_PI;

    float sin_v, cos_v;

    sin_v = sin(angle);
    cos_v = cos(angle);

    return vec2(cos_v, sin_v) * sqrt(alpha);
}
#endif
#define viewMAD(m, v) (mat3(m) * (v) + (m)[3].xyz)

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

#include "/lib/water/waterfuncs2.glsl"

#include "/lib/water/ssr_dh.glsl"

float GetBorderFogMixFactorCylinder(in vec3 eyePlayerPos, in float far, bool isWater)
{

    float mixval = 0.75;

    if (isWater)
        mixval = 0.33;
    float eyeDist = length(eyePlayerPos.xz);
    float borderFogFactor = smoothstep(far * mixval, far, eyeDist);

    return borderFogFactor;
}

vec4 getSpecularProperties(vec2 tcoord)
{
    float reflectance = labvalue.x;
    float smoothness = labvalue.y;
    float sss = labvalue.z;
    float emissives = 0;
#ifdef LAB_PBR
    if (iswater < 0.99)
    {

        // vec4 specularTex = texture2DLod(specular, tcoord, 0);
        vec4 specularTex = texture(specular, tcoord);

        smoothness = specularTex.x;
        sss = specularTex.z;
        reflectance = specularTex.y;
        emissives = specularTex.w;
    }
#endif
    return vec4(sss, emissives, reflectance, smoothness);
}

////
float phaseg(float x, float g)
{
    float gg = g * g;
    return (gg * -0.25 + 0.25) * pow(-2.0 * (g * x) + (gg + 1.0), -1.5) / PI;
}
float phaseRayleigh(float cosTheta)
{
    return cosTheta * 0.18 + 0.51;
}
float GetBorderFogMixFactorCube(in vec3 eyePlayerPos, in float far)
{
    // Calculate how far inside the cube bounds the point is (in XZ plane)
    vec2 absPos = abs(eyePlayerPos.xz); // distance from center
    vec2 halfSize = vec2(far - 32);     // half extents of the cube

    // Get how close we are to the edge on each axis
    vec2 edgeDist = halfSize - absPos;

    // The minimum distance to any XZ edge
    float minDistToEdge = min(edgeDist.x, edgeDist.y);

    // Start blending when within the outer 25% of the cube
    float blendStart = far - 32;

    // Cubic blend as we get closer to the cube edge
    float t = clamp(1.0 - minDistToEdge / blendStart, 0.0, 1.0);
    float borderFogFactor = t * t * t;

    return borderFogFactor;
}

void waterNoLoop(
    float rayLength, float dY, float estEyeDepth,
    vec3 refractedSunVec, vec3 ambient, vec3 sunColor,
    inout vec3 absorbance_w, inout vec3 vL_w, vec3 worldPos)
{
    //----------------------------------------------------------------------------
    // Initialization and coefficient setup
    //----------------------------------------------------------------------------

    // Compute the dot product between the sun direction and the normalized world position
    float SdotV = dot(sunPosWorld, normalize(worldPos));

    // Water-specific scattering coefficients (assumed defined elsewhere)
    vec3 mieCoeff = dirtScatterCoef;
    vec3 scatterCoeff = totEpsilon + mieCoeff;

    // Precompute the phase functions and constant Rayleigh scattering contribution,
    // which remains the same in every iteration.
    float mieTerm = phaseg(SdotV, 0.4);

    // Set light caustic factor
    float sunCaustics = 0.5;

    // Determine the view ray direction in world space

    // Initialize accumulators
    float sh = 1.0;

    //----------------------------------------------------------------------------
    // Loop over view samples along the ray
    //----------------------------------------------------------------------------

    float d = 0.4125;
    float dd = 1.010932;

    //----------------------------------------------------------------------------
    // Compute local light contributions
    //----------------------------------------------------------------------------
    vec3 rayleighCoeff = vec3(0.0);

    // Calculate sun lighting with caustics applied
    vec3 sunLight = sunColor * sh * sunCaustics;

    // Compute the difference between the eye depth and current step depth
    float eyeDepthDiff = max(estEyeDepth - dY * d, 0.0);

    // Exponential attenuation factors for ambient and sun light
    vec3 ambientAtten = exp(-eyeDepthDiff * rayleighCoeff);
    vec3 sunAtten = exp(-eyeDepthDiff / abs(refractedSunVec.y) * totEpsilon);
    vec3 mieContributionScaled = mieTerm * sunAtten;

    vec3 totalMie = mieCoeff * mieContributionScaled;
    vec3 totalScatter = totalMie;

    // Combine sun and ambient light contributions
    vec3 sunContribution = sunLight * totalScatter;
    vec3 ambientContribution = ambient * ambientAtten * (rayleighCoeff + mieCoeff);
    vec3 lightContribution = sunContribution + ambientContribution;

    //----------------------------------------------------------------------------
    // Accumulate in-scattering (light) and update absorbance
    //----------------------------------------------------------------------------
    float attenuationDepth = dd * rayLength;
    vec3 stepAttenuation = exp(-scatterCoeff * attenuationDepth);
    vL_w += (lightContribution - lightContribution * stepAttenuation) / (scatterCoeff + 1e-8) * absorbance_w;
    absorbance_w *= stepAttenuation;

    // Accumulate shade factor for averaging later
}
mat3 tbn_from_world_normal(vec3 N)
{
    // Normalize the input normal just to be safe
    N = normalize(N);

    // Choose an arbitrary vector that is not parallel to the normal
    vec3 arbitrary = abs(N.y) < 0.999 ? vec3(0.0, 1.0, 0.0) : vec3(1.0, 0.0, 0.0);

    // Compute the tangent vector as a vector orthogonal to the normal
    vec3 T = normalize(cross(arbitrary, N));

    // Compute the bitangent as the cross product of the normal and the tangent
    vec3 B = cross(N, T); // No need to normalize, it is already orthogonal

    // Construct and return the TBN matrix
    return mat3(T, B, N);
}
/*RENDERTARGETS: 1,5*/
void main()
{
    float maxOverdrawDistance = far;
    vec3 p3 = toWorldSpace(viewVector);

    float distancefade = min(max(1.0 - length(p3) / clamp(far - 16 * 4, 16, maxOverdrawDistance), 0.0) * 5, 1.0);

    bool waterMask = (iswater > 0.99 || isEyeInWater == 1);
    float mixfactor = GetBorderFogMixFactorCube(p3, far);

    gl_FragData[1] = waterMask ? vec4(1, 0, 0, 0.95) : vec4(0, 0, 1, 0.1);
    if (texture2D(depthtex1, gl_FragCoord.xy * texelSize).x < 1.0 || distancefade > 0.0 && waterMask)
    {
        gl_FragData[1] = vec4(0.0);
    }

    if (length(p3) < clamp(far - 16 * 4, 16, maxOverdrawDistance))
    {
        //      discard;
        //      return;
    }
    vec4 albedo = color;

    /////
    const vec3 wcolor = vec3(0.18, 0.35, 0.43) * 1.0;
    vec2 texc = gl_FragCoord.xy * texelSize;
    vec2 texcoord = lmtexcoord.xy;
    vec3 prevtexc = Reproject(vec3(texc, gl_FragCoord.z));
    float mask = texture(colortex4, texc.xy).a;
    bool isGlassWater = mask > 0.9;
    vec4 materialProps = getSpecularProperties(texcoord);
    float f0 = 0.002;
    vec4 outcolor;

    /////

    vec3 normFragpos = normalize(viewVector);
    vec3 normal = normal1;
    vec3 normalWorld = normal1;
    vec3 normalTex = vec3(0.0);
    mat3 TBNUP = tbn_from_world_normal(viewToWorld(normal0));

    if (waterMask)
    {

        vec3 posxz = p3 + cameraPosition;

        normalTex = waterNormal(posxz.xz - posxz.y, normFragpos);

        normal = normalize(TBNUP * (normalTex * 2.0 - 1.0));
        normalWorld = worldToView(normal);
    }

    albedo.rgb = toLinear(albedo.rgb * color.rgb);
    #ifndef VANILLA_WATER

    outcolor = waterMask ? vec4(mix(toLinear(wcolor), pow(color.rgb / color.a, vec3(1.85)), 0.25), 0.5) : albedo;

    #else
    //   outcolor = waterMask ? vec4(albedo.rgb, 0.5) : albedo;
    #endif

    float alpha0 = waterMask ? 0.1 : outcolor.a;

    // float diffuseSun = mix(max(dot(normal, lightPos), 0.002), max(dot(normal, lightPos), 0.0), outcolor.a) * lmtexcoord.w;
    float diffuseSun = max(dot(normal, lightPos), 0.0);
    //  diffuseSun = mix(max(diffuseSun, 1.0 - outcolor.a), diffuseSun, outcolor.a);
    diffuseSun = diffuseSun * lmtexcoord.w;

    vec3 direct = sunLight;
    float shading = 1.0;

    #ifdef OVERWORLD
        #ifdef WATER_SHADOWS
    if (diffuseSun > 0.0)
    {
        float noise = R2_dither(gl_FragCoord.xy);

        vec3 ProjShadowPos = mat3(shadowModelView) * p3 + shadowModelView[3].xyz;
        ProjShadowPos = diagonal3(shadowProjection) * ProjShadowPos + shadowProjection[3].xyz;

        float distortFactor = calcDistort(ProjShadowPos.xy);
        ProjShadowPos.xy *= distortFactor;

        if (all(lessThan(abs(ProjShadowPos.xy), (vec2(1.0, 1.0) - 1.5 / shadowMapResolution))) &&
            abs(ProjShadowPos.z) < 6)
        {
            float threshMulMult = mix(2048, 4096, float(eyeAltitude > 400));
            float threshMulMult2 = mix(threshMulMult, 8192, float(eyeAltitude > 500));
            float threshMul = max(threshMulMult2 / shadowMapResolution * shadowDistance / 100.0, 0.95);
            float distortThresh = clamp(sqrt(1.0 - diffuseSun * diffuseSun) / diffuseSun, 0.0, 0.25) / distortFactor;
            float diffthresh = distortThresh / 6000.0 * threshMul;

            ProjShadowPos = ProjShadowPos * vec3(0.5, 0.5, 0.5 / 6.0) + 0.5;

            shading = 0.0;
            float rdMul = 4.0 / shadowMapResolution;
            for (int i = 0; i < 9; i++)
            {
                vec2 offsetS = tapLocation(i, 9, 2.0, noise, 0.0);

                float weight = 1.0 + (i + noise) * rdMul / 9.0 * shadowMapResolution;
                vec3 shadowCoordWeighted = vec3(ProjShadowPos + vec3(rdMul * offsetS, -diffthresh * weight));
                float shadow0 = texture(shadowtex1, shadowCoordWeighted);
            #ifdef COLORED_SHADOWS
                float shadow1 = texture(shadow, shadowCoordWeighted);

                float transparentshadow = distance(shadow1, shadow0);
                vec4 shadowcolor = texture(shadowcolor0, shadowCoordWeighted.xy);

                if (transparentshadow > 0)
                {
                    shading += clamp(shadow1 + clamp((1 - shadowcolor.a), 0.0, 1.0), 0.0, 1.0) / 9;
                }
                else
                {
                    shading += shadow1 / 9;
                }
            #else
                shading += shadow0 / 9;

            #endif
            }
        }

        shading = mix(0.0, shading, shadowblend);

        diffuseSun = min(shading, diffuseSun) * lmtexcoord.w;

        direct *= shading;
    }
        #endif
    #endif

    direct *= (1 - rainStrength * 0.9);
    diffuseSun *= (1 - rainStrength * 0.9);
    vec3 ambient = calcAmbientLight(normal, lmtexcoord.zw, atmosphereUp, diffuseSun, torch);
    outcolor.rgb += (materialProps.y * 8.0 * outcolor.rgb * outcolor.rgb);

    float roughness = 0.01;

    /////////

    vec3 diffuse = ambient * outcolor.rgb * diffuseSun;

    vec3 transmission = ambient * outcolor.rgb;

    outcolor.rgb = mix(transmission, diffuse, outcolor.a * outcolor.a);

    outcolor = reflections(lmtexcoord.w, normal, viewVector, materialProps, outcolor, diffuseSun, albedo.rgb, alpha0);

    if (!waterMask && isGlassWater || (isEyeInWater == 1 && !waterMask))
    {
        float estEyeDark = clamp((eyeBrightnessSmooth.y / 255.0), 0.0, 1.0);

        float estEyeDepth = clamp((14.0 - eyeBrightnessSmooth.y / 255.0 * 16.0) / 14.0, 0.0, 1.0);
        estEyeDepth *= estEyeDepth * estEyeDepth * 32.0;

        vec3 fragpos = viewVector;

        float rayLength = length(fragpos);
        if (isEyeInWater == 1)
        {
            float maxZ = (min(rayLength, 32.0) / (1e-8 + rayLength));

            rayLength = rayLength * maxZ;
        }

        float dY = normalize(p3).y * rayLength;
        vec3 refractedSunVec = refract(lightPos, -vec3(0.0, 1.0, 0.0), 0.9);
        vec3 ambient1 = atmosphereUp;
        if (isEyeInWater == 0)
            ambient1 *= 0.5;
        vec3 sunColor = sunLight;
        vec3 absorbance_w1 = vec3(1.0);
        vec3 vL_w1 = vec3(0.0);
        waterNoLoop(rayLength, dY, estEyeDepth, refractedSunVec, ambient1, sunColor, absorbance_w1, vL_w1, p3);
        if (isEyeInWater == 0)
            vL_w1 *= estEyeDark;
        outcolor.rgb *= absorbance_w1;
        outcolor.rgb += vL_w1;
    }

    if (waterMask && !(normal1.g < -0.1) && isEyeInWater == 1)
    {
        gl_FragData[1] = vec4(0, 0, 0, 1);
        //      outcolor.a = 0;
    }

    if (texture2D(depthtex1, gl_FragCoord.xy * texelSize).x < 1.0 || distancefade > 0.0)
    {
        outcolor.a = 0;
    }

    // outcolor.a = 1;
    // outcolor.a = mix(outcolor.a, 0, 1 - mixfactor);
    // outcolor.rgb = diffuse;

    gl_FragData[0] = clamp(outcolor, 0, 1000);
}
