

varying vec4 color;
varying vec4 lmtexcoord;
varying vec3 normal;
varying vec3 normal1;
flat varying vec4 labvalue;

flat varying vec3 ambientLight;

#include "/lib/light.glsl"
#include "/lib/specular.glsl"

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
float R2_dither3()
{
    vec2 alpha = vec2(0.75487765, 0.56984026);
    return fract(alpha.x * gl_FragCoord.x + alpha.y * gl_FragCoord.y + 1.0 / 1.6180339887 * frameCounter);
}

vec2 tapLocation(int sampleNumber, int nb, float nbRot, float jitter, float distort)
{
    float alpha = (sampleNumber + jitter) / nb;
    float angle = jitter * 6.28 + alpha * nbRot * 6.28;

    float sin_v, cos_v;

    sin_v = sin(angle);
    cos_v = cos(angle);

    return vec2(cos_v, sin_v) * sqrt(alpha);
}
float phaseg(float x, float g)
{
    float gg = g * g;
    return (gg * -0.25 + 0.25) * pow(-2.0 * (g * x) + (gg + 1.0), -1.5) / PI;
}
#if CLOUD_STYLE == 2

    #include "/lib/clouds/clouds_loop_a.glsl"
#else
    #ifdef ALT_CLOUDS
        #include "/lib/clouds/clouds_bloop_a.glsl"
    #else
        #include "/lib/clouds/clouds_bloop.glsl"
    #endif
#endif
float cloudShadow(vec3 eyePlayerPos, float noise)
{

    const int rayMarchSteps = 6;
    vec3 rPos = eyePlayerPos + cameraPosition;
#if CLOUD_STYLE == 2

    vec2 wind = windGenerator(cloudTime * 0.01);
#else
    vec2 wind = vec2(0.0);
#endif
    float cloudShadow = 0.0;
    float dither = 0.5;
    for (int i = 0; i < rayMarchSteps; i++)
    {

        vec3 cloudPos = rPos + sunPosWorld / abs(sunPosWorld.y) * (cloud_height + (dither + i) / rayMarchSteps * cloud_height_max - rPos.y);

        cloudShadow += getCloudDensity(cloudPos, 1, wind);
    }
    cloudShadow /= rayMarchSteps;
    cloudShadow = mix(1.0, exp(-cloudShadow * cloudDensity * cloud_height_max / rayMarchSteps), mix(0.9, 1.0, rainStrength));
    return cloudShadow;
}

float rayTraceShadowAlt(vec3 prevfrag, vec3 sundir, float dither, bool sss)
{
    int maxSteps = 16;

    // Clip-space starting point for ray
    vec3 clipPosition = toClipSpace3DH(prevfrag);
    vec3 direction = normalize(toClipSpace3DH(prevfrag + sundir) - clipPosition);

    // Optional: limit how far the ray travels (sun shadows are long, so maybe scale it)
    float maxDistance = mix(0.1, dither * 0.1, float(sss)); // normalized clip space distance
    vec3 stepv = direction * maxDistance / float(maxSteps);

    // Random offset to reduce banding/flickering
    vec3 spos = clipPosition + stepv * dither;

    for (int i = 0; i <= maxSteps; ++i)
    {
        if (any(lessThan(spos.xy, vec2(0.0))) || any(greaterThan(spos.xy, vec2(1.0))))
            break;

        float depthSample = decodeDepthBias(texture(colortex13, spos.xy).b);

        // Discard garbage depth (uninitialized, sky, off-screen reprojection)
        if (depthSample <= 0.0001 || depthSample >= 0.9999)
            continue;

        // Only occlude if the sample is truly in front
        if (depthSample < spos.z)
        {
            float dist = abs(ld(depthSample) - ld(spos.z)) / ld(spos.z);
            if (dist < 0.05)
                return 0.0;
        }
        spos += stepv;
    }

    return 1.0;
}
vec3 computeProjectedShadowPos(vec3 p3, mat3 shadowMV3, vec3 shadowProjDiag, vec3 shadowProjTrans)
{
    vec3 shadowMV_P3 = shadowMV3 * p3;
    vec3 shadowMV_Trans = shadowModelView[3].xyz;
    vec3 ProjShadowPos = shadowProjDiag * (shadowMV_P3 + shadowMV_Trans) + shadowProjTrans;
    vec3 shadowMV_Normals = shadowMV3 * normal1;
    ProjShadowPos += shadowProjDiag * shadowMV_Normals * 0.15;

    return ProjShadowPos;
}

float shadowFunc(float diffuseSun, float sssAmount, vec3 p3, float noise, vec2 lightmap, vec3 fragpos)
{
    float shading = 0.0;

    // === Precompute shadow projection inputs ===
    mat3 shadowMV3 = mat3(shadowModelView);
    vec3 shadowProjDiag = vec3(shadowProjection[0].x, shadowProjection[1].y, shadowProjection[2].z);
    vec3 shadowProjTrans = shadowProjection[3].xyz;

    // === Project world-space position into shadow map space
    vec3 ProjShadowPos = computeProjectedShadowPos(p3, shadowMV3, shadowProjDiag, shadowProjTrans);

    // === Apply shadow distortion (nonlinear range warping)
    float distort = calcDistort(ProjShadowPos.xy);
    ProjShadowPos.xy *= distort;

    // === Convert to texture space (0–1 range, 6 slices depth)
    ProjShadowPos = ProjShadowPos * vec3(0.5, 0.5, 0.5 / 6.0) + 0.5;

    // === Clamp check — skip shadowing if outside shadow texture bounds
    if (ProjShadowPos.x < 0.0 || ProjShadowPos.x > 1.0 ||
        ProjShadowPos.y < 0.0 || ProjShadowPos.y > 1.0)
    {
        shading = 1.0;
    }
    else
    {
        // === Subsurface Scattering Approximation for voxel geometry
        if (sssAmount > 0.0)
        {
            float ndotl = dot(normal, lightPos);
            float backLit = max(dot(-lightPos, normal), 0.0);
            float sideLit = 1.0 - abs(ndotl);
            float sssBoost = mix(backLit, sideLit, 0.5) * sssAmount;
            diffuseSun = max(diffuseSun, sssBoost);
        }

        // === Slope-based bias with distortion compensation
        float ndotl = dot(normal, lightPos);
        float slope = clamp(1.0 - ndotl, 0.0, 1.0);
        float distortComp = 1.0 + distort * 1.5;

        float bias = max(0.00005, 0.0007 * slope * distortComp);

        // === Apply depth offset for acne reduction
        ProjShadowPos.z -= bias;

        // === Sample shadow map
        shading = texture(shadow, ProjShadowPos);
    }

#ifdef CLOUD_SHADOWS
    float cloudshadow = cloudShadow(p3, noise);
    shading = min(cloudshadow, shading);
#endif

    // === Final light calculations
    shading = mix(1.0, shading, nightblendShadows);
    diffuseSun = diffuseSun * shading * lightmap.y;
    diffuseSun *= lightmap.y * (1.0 - rainStrength * 0.9);

    return diffuseSun;
}

float shadowFuncAlt(float diffuseSun, float sssAmount, vec3 p3, float noise, vec2 lightmap, vec3 fragpos)
{

    float shading = 0.0;

    shading = rayTraceShadowAlt(fragpos, worldToView(lightPos), noise, (sssAmount > 0.0));
#ifdef CLOUD_SHADOWS
    shading = cloudShadow(p3, noise);
#endif

    shading = mix(1.0, shading, nightblendShadows);

    diffuseSun = diffuseSun * shading * lightmap.y;
    diffuseSun *= lightmap.y * (1 - rainStrength * 0.9);
    return diffuseSun;
}

void applyNoise_full(inout vec3 fragColor,
                     in vec3 worldPos,
                     in float viewDist)
{
    vec3 posxz = worldPos;

    const float uNoiseCells = 16;
    const float uMulIntensity = 0.22;
    const float dropoffDist = 1024.0;
    vec3 mixed = fragColor;

    vec2 blockUV = fract(posxz.xz - posxz.y) * uNoiseCells;
    blockUV = floor(blockUV) / uNoiseCells;
    vec2 noiseUV = blockUV;

    float b = texture(noisetex, noiseUV).a;

    float n = b * 2.0 - 1.0;

    mixed *= 1.0 + n * uMulIntensity;

    mixed = clamp(mixed, 0.0, 1.0);
    vec3 noisy = mixed;

    float fade = clamp(viewDist / dropoffDist, 0.0, 1.0);
    fragColor = mix(noisy, fragColor, fade);
    // fragColor = vec3(noisy);
}

float ComputeOcclusion(vec2 prevUV, vec3 fragpos2)
{
    if (any(lessThan(prevUV, vec2(0.0))) || any(greaterThan(prevUV, vec2(1.0))))
        return 1.0;

    const float PI2 = 6.2831853;
    float fovScale = dhProjection[1][1] * 0.36397;

    float maxDist2 = fragpos2.z * fragpos2.z * fovScale * 0.05648;
    float sampleRadius = fovScale * 0.04;

    // Random rotation and offset
    const vec2 noiseScale = vec2(0.5, 6.2831853); // 0.5, 2π
    vec2 noise = blueNoise(gl_FragCoord.xy) * noiseScale;

    float alpha = noise.x;

    float occlusion = 0.0;
    float sampleCount = 0.0;

    for (int i = 0; i < 4; ++i)
    {

        float angle = float(i) * 1.5707963 + noise.y;

        vec2 offsetDir = vec2(cos(angle), sin(angle)) * alpha;
        vec2 offsetPixels = offsetDir * sampleRadius * vec2(viewWidth, viewHeight * aspectRatio);
        ivec2 texelCoord = ivec2(prevUV * viewResolution + offsetPixels);

        if (texelCoord.x >= 0 && texelCoord.y >= 0 &&
            texelCoord.x < viewWidth && texelCoord.y < viewHeight)
        {

            float depth = decodeDepthBias(texelFetch2D(colortex13, texelCoord, 0).b);
            vec3 samplePos = toScreenSpaceDH(vec3(texelCoord * texelSize + 0.5 * texelSize, depth));
            vec3 delta = samplePos - fragpos2;
            float dist2 = dot(delta, delta);

            if (dist2 > 1e-5)
            {
                if (dist2 < maxDist2)
                {
                    float NdotV = clamp(dot(delta * inversesqrt(dist2), normalize(normal)), 0., 1.);
                    occlusion += NdotV * clamp(1.0 - dist2 / maxDist2, 0.0, 1.0);
                }
                sampleCount += 1.0;
            }
        }
    }

    return (sampleCount > 0.0) ? clamp(1.0 - occlusion / sampleCount * 1.4, 0.0, 1.0) : 1.0;
}

vec3 computeLighting(vec3 precomputedAmbient, float diffuseSun, vec2 lmtexcoord)
{

    // Cache lightmap.x to avoid redundant swizzles.
    float lm = lmtexcoord.x;

    // Initialize torch color.
    vec3 torch = vec3(3.000, 1.3, 0.42);
#ifdef OLD_LIGHT
    // Apply lightmap power.
    float lightmapPow = lm * lm * lm * lm;
    float lightFactor = lightmapPow + lm * 0.025;
    torch *= lightFactor;
    torch = clamp(torch, 0.0, 4.0) * 2.0;
#else

    float lightmapPow = lm * lm * lm;
    float lightFactor = lightmapPow + lm * 0.025;
    torch *= lightFactor;
    torch = clamp(torch, 0.0, 4.0) * 1.5;

#endif

    float mixstrength = clamp(pow(shadowblend, 0.3), 0.0, 1.0);
    float oneMinusMixStrength = 1.0 - mixstrength;

    vec3 sun = sunLight;
#ifndef SHADOWS_ENABLED
    // Calculate luma (luminosity / perceived brightness)
    float luma = dot(sun.rgb, vec3(0.299, 0.587, 0.114));
    float vibranceFactor = 1.5;
    sun.rgb = mix(vec3(luma), sun.rgb, vibranceFactor);
#endif

#ifndef OVERWORLD
    sun = mix(sunLight, vec3(1), 0.5) * 0.01;
#endif

    float skymap = 1.0;
#ifndef OVERWORLD
    skymap = 1.0;
#else
    skymap = lmtexcoord.y;
#endif

    float diffuseSunClamped = clamp(diffuseSun, 0.5, 1.0);

    float bounceFactor = (0.15 * diffuseSunClamped) * oneMinusMixStrength + 0.25;
    vec3 bounce = sun * bounceFactor * skymap;

#ifdef NETHER
    bounce = vec3(1, 0.3, 0.12) * 3.0;
#endif

#ifdef END
    bounce = vec3(1, 0.3, 0.12) * 2.0;
#endif

    // Mix precomputed ambient with bounce lighting
    vec3 ambientCombined = precomputedAmbient * 0.9 + bounce * 0.1;

    // Calculate diffuse lighting
    vec3 diffuseLight = diffuseSun * sun + ambientCombined;

    // Compute darkness factors
    float darknessFactor = darknessLightFactor * darknessLightFactor * darknessLightFactor;
    diffuseLight *= (1.0 - 6.0 * darknessFactor);

    // Torch and small light contributions
    vec3 torchContribution = torch * hdrMulttorch;
    float screenBrightnessTerm = 1.0 + screenBrightness * MIN_LIGHT_BOOST;
    vec3 smallLightContribution = vec3(0.002, 0.005, 0.006) * screenBrightnessTerm;

    vec3 light = max(diffuseLight + torchContribution + smallLightContribution, 0.001);
    light *= 1.0 - darknessLightFactor;

    return light;
}

/* RENDERTARGETS: 10 */
void main()
{
    vec3 fragPosScreen = toScreenSpaceDH(gl_FragCoord.xyz * vec3(texelSize, 1.0));
    vec3 p3 = toWorldSpace(fragPosScreen);

    // Early depth / fog discard
    float depthFactor = 1.0 - length(p3) / clamp(far - 32.0, 32.0, far);
    if (depthFactor > 0.0)
        discard;

    // Material / lighting inputs -------------------------------------------
    vec3 prenoise = color.rgb;
    float dither = R2_dither3(); // cached once per-fragment
    float sss = labvalue.z * dither;
    float diffuseSun = max(dot(normal1, lightPos), 0.0);

    // Reconstruct previous-frame position -----------------------------------
    vec3 worldPos = p3 + cameraPosition;

    // Convert gl_FragCoord to clip space
    vec2 fragCoordNorm = gl_FragCoord.xy / vec2(viewWidth, viewHeight);
    vec4 currClipPos = vec4(fragCoordNorm * 2.0 - 1.0, gl_FragCoord.z * 2.0 - 1.0, 1.0);

    // View-space reconstruction
    vec4 currViewPos = gbufferProjectionInverse * currClipPos;
    currViewPos /= currViewPos.w;
    vec4 worldPos2 = gbufferModelViewInverse * currViewPos - gbufferModelViewInverse[3];

    // Project into previous frame
    vec4 prevClip = gbufferPreviousProjection * gbufferPreviousModelView * worldPos2;
    vec3 prevNDC = prevClip.xyz / prevClip.w;
    vec2 prevUV = prevNDC.xy * 0.5 + 0.5;

    float prevDepth = decodeDepthBias(texture(colortex13, prevUV).b);
    vec3 fragPosPrev = toScreenSpaceDH(vec3(prevUV, prevDepth));

    // Sun shadows -----------------------------------------------------------
#ifdef DH_SHADOWMAP
    diffuseSun = shadowFunc(diffuseSun, sss, p3, dither, lmtexcoord.zw, fragPosScreen);
#else
    diffuseSun = shadowFuncAlt(diffuseSun, sss, p3, dither, lmtexcoord.zw, fragPosPrev);
#endif

    // Luminance-adaptive material terms -------------------------------------
    float lumaRatio = max(luma(prenoise) / luma(color.rgb), 0.0);
    float reflectance = labvalue.x;
    float smoothness = labvalue.y * lumaRatio;

    float rainMult = sqrt(lmtexcoord.w) * wetness;
    float roughness = mix(pow(1.0 - smoothness, 2.0), 0.01, rainMult);

    // Specular (GGX) --------------------------------------------------------
    vec3 viewDir = -normalize(p3);
    vec3 specular = diffuseSun *
                    GGX2(normal1, viewDir, lightPos, roughness, vec3(reflectance)) *
                    pow(lmtexcoord.w, 3.0) * sunLight;

    // Ambient & AO ----------------------------------------------------------
    float occlusion = ComputeOcclusion(prevUV, fragPosPrev);
    vec3 ambient = computeLighting(ambientLight, diffuseSun, lmtexcoord.zw);

    // Surface noise ---------------------------------------------------------
    float noiseVal = noise_standard(gl_FragCoord.xy) * 0.001 * 0;
    vec3 albedo = color.rgb;
    applyNoise_full(albedo, worldPos + noiseVal, length(fragPosScreen));

    // Final colour ----------------------------------------------------------
    vec3 finalRGB = ambient * occlusion * toLinear(albedo) + specular;
    gl_FragData[0] = vec4(vec3(finalRGB), color.a);
}
