

varying vec2 texcoord;

vec3 median(sampler2D tex1, ivec2 coords)
{
    vec3 v[9];

    // Fill the array 'v' with the color values from the 3x3 pixel window
    for (int dX = -1; dX <= 1; ++dX)
    {
        for (int dY = -1; dY <= 1; ++dY)
        {
            ivec2 offset = ivec2(dX, dY);
            v[(dX + 1) * 3 + (dY + 1)] = texelFetch(tex1, coords + offset, 0).rgb;
        }
    }

    // Selection sort to find the 5th smallest element
    for (int i = 0; i < 5; ++i)
    {
        int minIndex = i;
        for (int j = i + 1; j < 9; ++j)
        {
            if (v[j].r + v[j].g + v[j].b < v[minIndex].r + v[minIndex].g + v[minIndex].b)
            {
                minIndex = j;
            }
        }

        // Swap to bring the current smallest to the i-th position
        vec3 temp = v[i];
        v[i] = v[minIndex];
        v[minIndex] = temp;
    }

    // Return the median value, which is the 5th smallest element
    return v[4];
}

vec3 tonemap(vec3 col)
{
    // return col;
    return col / (1 + luma(col));
}
vec3 invTonemap(vec3 col)
{
    // return col;

    return col / (1 - luma(col));
}

float MinDepth3x3(vec2 uv)
{
    ivec2 fragCoord = ivec2(gl_FragCoord.xy);
    float depth = texelFetch(depthtex0, fragCoord, 0).x;

    for (int x = -1; x <= 1; ++x)
    {
        for (int y = -1; y <= 1; ++y)
        {
            if (x != 0 || y != 0)
            {
                depth = min(depth, texelFetch(depthtex0, fragCoord + ivec2(x, y), 0).x);
            }
        }
    }

    return depth;
}
vec3 untonemap(vec3 inp)
{
    return invTonemap(inp);
}

vec4 texelFetchYC(sampler2D tex, ivec2 uv, float numb)
{
    vec4 c = texelFetch(tex, ivec2(uv), 0);
    //    c.rgb = median(tex, uv);

    return vec4(tonemap(c.rgb), c.a);
}

// Fetch history pixel
vec4 fetchHistoryPx(ivec2 pix)
{
    return vec4(texelFetchYC(colortex9, pix, 0).xyz, 1.0);
}

// Cubic Hermite interpolation
vec3 CubicHermite(vec3 A, vec3 B, vec3 C, vec3 D, float t)
{
    float t2 = t * t;
    float t3 = t2 * t;
    vec3 a = -0.5 * A + 1.5 * B - 1.5 * C + 0.5 * D;
    vec3 b = A - 2.5 * B + 2.0 * C - 0.5 * D;
    vec3 c = -0.5 * A + 0.5 * C;
    vec3 d = B;
    return a * t3 + b * t2 + c * t + d;
}

vec3 BicubicHermiteTextureSample(vec2 P)
{
    vec2 pixel = P * viewResolution + 0.5;
    vec2 frac = fract(pixel);
    ivec2 ipixel = ivec2(pixel) - 1;

    vec3 C00 = fetchHistoryPx(ipixel + ivec2(-1, -1)).rgb;
    vec3 C10 = fetchHistoryPx(ipixel + ivec2(0, -1)).rgb;
    vec3 C20 = fetchHistoryPx(ipixel + ivec2(1, -1)).rgb;
    vec3 C30 = fetchHistoryPx(ipixel + ivec2(2, -1)).rgb;

    vec3 C01 = fetchHistoryPx(ipixel + ivec2(-1, 0)).rgb;
    vec3 C11 = fetchHistoryPx(ipixel + ivec2(0, 0)).rgb;
    vec3 C21 = fetchHistoryPx(ipixel + ivec2(1, 0)).rgb;
    vec3 C31 = fetchHistoryPx(ipixel + ivec2(2, 0)).rgb;

    vec3 C02 = fetchHistoryPx(ipixel + ivec2(-1, 1)).rgb;
    vec3 C12 = fetchHistoryPx(ipixel + ivec2(0, 1)).rgb;
    vec3 C22 = fetchHistoryPx(ipixel + ivec2(1, 1)).rgb;
    vec3 C32 = fetchHistoryPx(ipixel + ivec2(2, 1)).rgb;

    vec3 C03 = fetchHistoryPx(ipixel + ivec2(-1, 2)).rgb;
    vec3 C13 = fetchHistoryPx(ipixel + ivec2(0, 2)).rgb;
    vec3 C23 = fetchHistoryPx(ipixel + ivec2(1, 2)).rgb;
    vec3 C33 = fetchHistoryPx(ipixel + ivec2(2, 2)).rgb;

    vec3 CP0X = CubicHermite(C00, C10, C20, C30, frac.x);
    vec3 CP1X = CubicHermite(C01, C11, C21, C31, frac.x);
    vec3 CP2X = CubicHermite(C02, C12, C22, C32, frac.x);
    vec3 CP3X = CubicHermite(C03, C13, C23, C33, frac.x);

    return CubicHermite(CP0X, CP1X, CP2X, CP3X, frac.y);
}

void main()
{
    /* RENDERTARGETS: 9,0,1 */

    vec3 albedo = texture(colortex1, texcoord).rgb;
    float materials = texture(colortex3, texcoord).x;
    vec2 decoded2 = decodeVec2(materials);
    int metalidx = int(decoded2.x * 255);

    vec3 color = vec3(0.0);
    float z = texture(depthtex0, texcoord).x;
    ivec2 texel = ivec2(texcoord * viewResolution);

    vec3 scene = texture(colortex0, texcoord).rgb;
    vec3 scene2 = scene;

    if (z >= 1.0)
    {
        gl_FragData[1].rgb = scene;
        return;
    }

    if (metalidx < 229)
    {
        albedo = vec3(1.0);
    }
    else
    {
        scene2 = vec3(0.0);
    }

    vec3 test1, test2;
    decodeTwoVec3(texelFetch(colortex12, texel, 0), test1, test2);

    vec3 current = tonemap(((test1 + test2 * scene) * albedo) - scene2);

    float historyWeight = mix(0.5, 0.1, decoded2.y);
    bool hand = texture(depthtex2, texcoord).x > z;
    vec3 position = vec3(texcoord, MinDepth3x3(texel));
    vec3 reprojectedPosition = Reproject(position);
    float offcenter_rej = 0.1;

    if (hand)
    {
        historyWeight = 0.0;
    }

    vec3 history = BicubicHermiteTextureSample(reprojectedPosition.xy);

    ivec2 reprojPix = ivec2(reprojectedPosition.xy * viewResolution);
    vec3 h00 = fetchHistoryPx(reprojPix + ivec2(-1, -1)).rgb;
    vec3 h10 = fetchHistoryPx(reprojPix + ivec2(0, -1)).rgb;
    vec3 h20 = fetchHistoryPx(reprojPix + ivec2(1, -1)).rgb;
    vec3 h01 = fetchHistoryPx(reprojPix + ivec2(-1, 0)).rgb;
    vec3 h11 = fetchHistoryPx(reprojPix + ivec2(0, 0)).rgb;
    vec3 h21 = fetchHistoryPx(reprojPix + ivec2(1, 0)).rgb;
    vec3 h02 = fetchHistoryPx(reprojPix + ivec2(-1, 1)).rgb;
    vec3 h12 = fetchHistoryPx(reprojPix + ivec2(0, 1)).rgb;
    vec3 h22 = fetchHistoryPx(reprojPix + ivec2(1, 1)).rgb;

    vec3 minPast = min(min(min(h00, h10), min(h20, h01)),
                       min(min(h11, h21), min(h02, min(h12, h22))));
    vec3 maxPast = max(max(max(h00, h10), max(h20, h01)),
                       max(max(h11, h21), max(h02, max(h12, h22))));

    float err = clamp(length(current - history), 0.0, 1.0);

    current = mix(current, clamp(current, minPast, maxPast), err);

    color = mix(current, history, clamp(historyWeight, 0, 1));

    color = untonemap(color);
    vec3 outc = color;

    color += scene2;

    gl_FragData[0].rgb = outc;
    gl_FragData[1].rgb = color;
    gl_FragData[2] = vec4(0.0);
}