/* Optimized SSR Shader */
#extension GL_ARB_gpu_shader5 : enable

// Varyings
flat varying vec3 ambientUp, ambientDown, ambientLeft, ambientRight, ambientB, ambientF;
flat varying float ambientA;
varying vec2 texcoord;

#if SSR_QUALITY == 2
    #include "/lib/reflection_lib_fast.glsl"
#endif
#if SSR_QUALITY == 3
    #include "/lib/reflection_lib.glsl"
#endif

void main()
{
#ifdef SSR_ACCUMULATION
    /* RENDERTARGETS: 0,1,9 */
#else
    /* RENDERTARGETS: 0,1 */
#endif

    vec2 texSize = viewResolution / textureSize(colortex12, 0);
    vec2 fragUV = gl_FragCoord.xy * texSize;

    float z = texture(depthtex0, texcoord).x;
    bool occluded = texture(depthtex2, texcoord).x > z;

#ifdef TAA
    vec2 uvOffset = (offsets[framemod8] * texelSize * 0.5);
#else
    vec2 uvOffset = vec2(0.0);
#endif

    vec3 ndc = vec3(texcoord - uvOffset, z);
    vec3 fragPos = toScreenSpace(ndc);

    // Material & scene data
    vec4 matSample = texelFetch(colortex3, ivec2(fragUV), 0);
    vec4 normSample = texelFetch(colortex2, ivec2(fragUV), 0);
    vec3 sceneColor = texture(colortex0, texcoord).rgb;
    vec2 matInfo = decodeVec2(matSample.x);
    vec3 normal = decodeNormal(normSample.rg);
    vec2 lightmap = decodeVec2(normSample.b);
    float reflectivity = matInfo.x;
    float smoothness = matInfo.y;

    // Early out when no reflection
    if (z >= 1.0 || smoothness < REFLECTION_CUTOFF)
    {
        gl_FragData[0].rgb = sceneColor;
        return;
    }

    vec3 albedo = texture(colortex1, texcoord).rgb;
    vec3 f0 = vec3(reflectivity);
    vec3 accumA = vec3(0.0), accumB = vec3(0.0);

    // Compute SSR
    vec3 refl = computeReflections(albedo, lightmap.y, smoothness, f0, normal, fragPos, matInfo.y, sceneColor, occluded, accumA, accumB);
#ifdef SSR_ACCUMULATION
    bool isDielectric = reflectivity < 229.0 / 255.0;
    vec3 scene2Factor = isDielectric ? sceneColor : vec3(0.0);
    vec3 reflColor = refl.rgb - scene2Factor;

    vec3 projPos = Reproject(vec3(texcoord, z));

    bool invalid = projPos.x < 0.0 || projPos.y < 0.0 || projPos.x > 1.0 || projPos.y > 1.0 || occluded;
    if (invalid) {
        gl_FragData[0].rgb = reflColor + scene2Factor;
        gl_FragData[1] = vec4(0.0);
        gl_FragData[2] = vec4(reflColor, reflectivity + smoothness * 0.9);
        return;
    }

    vec4 histSample = texture(colortex9, projPos.xy);
    float diff = clamp(length(reflColor - histSample.rgb) / max(1e-5, luma(histSample.rgb)) * 0.5, 0.0, 1.0);
    vec2 pcd = 1.0 - abs(2.0 * fract(projPos.xy * viewResolution) - 1.0);
    diff *= mix(0.9, sqrt(pcd.x * pcd.y) * 0.1 + 0.9, 1.0);
    float motion = clamp(length((projPos.xy - texcoord) / texelSize), 0.0, 1.0) * 0.25;
    float matReject = pow(distance(reflectivity + smoothness * 0.9, histSample.a), 2.0);
    float blendFactor = clamp(diff - motion - matReject, 0.0, 0.75);
    vec3 finalColor = mix(reflColor, histSample.rgb, blendFactor);

    gl_FragData[0].rgb = finalColor + scene2Factor;
    gl_FragData[1] = vec4(0.0);
    gl_FragData[2] = vec4(finalColor, reflectivity + smoothness * 0.9);
#else


    gl_FragData[0].rgb = refl;
    gl_FragData[1] = vec4(0.0);
#endif
}