

#define waterfog
varying vec2 texcoord;

void main()
{

    /* RENDERTARGETS: 0 */

    float z = texture(depthtex0, texcoord).x;

    float z0DH = texture(dhDepthTex0, texcoord).x;
    vec3 DH = texture(colortex10, texcoord).rgb;
    vec3 sky = texture(colortex8, texcoord).rgb;

    if (z0DH >= 1.0)
    {
        DH = sky;
    }

    vec3 fragpos = toScreenSpace(vec3(texcoord, z));

    vec3 p3 = toWorldSpace(fragpos);
    float dist = length(p3);
    float fadeDist = 32.0;

    vec3 color = texture(colortex0, texcoord.xy).rgb;
    float blend = smoothstep(far - fadeDist, far, dist);

    color.rgb = mix(color, DH, blend);

    gl_FragData[0].rgb = vec3(color.rgb);
}
