
#extension GL_ARB_shader_image_load_store : enable
#extension GL_ARB_shading_language_packing : enable
#define waterfog
varying vec2 texcoord;

float phaseg(float cos_theta, float g)
{
    const float k = 0.0795774715459;
    return k * (1.0 - g * g) / (pow(1.0 + g * g - 2.0 * g * cos_theta, 1.5));
}

        #include "/lib/clouds/clouds_bloop_a.glsl"

float gbf(in vec3 eyePlayerPos, in float far, in float z0)
{
    float distXZ = length((vec3(eyePlayerPos.x, 0.0, eyePlayerPos.z)).xyz);
    float distY = length((vec3(0.0, eyePlayerPos.y, 0.0)).xyz);
    float eyeDist = max(distXZ, distY);
#ifdef DISTANT_HORIZONS
    float borderFogFactor = smoothstep(0.0, dhRenderDistance, eyeDist);
    borderFogFactor *= borderFogFactor * borderFogFactor;
    return borderFogFactor;
#else

    float borderFogFactor = smoothstep(far * 0.5, far, eyeDist);
    borderFogFactor *= borderFogFactor * borderFogFactor;

    return borderFogFactor;

#endif
}

void main()
{
    /* RENDERTARGETS: 8 */

    vec2 refractedCoord = texcoord;
    bool isWater = texture(colortex5, refractedCoord).r > 0.5;

    float z0 = texture(depthtex0, refractedCoord).x;

    bool isHand = z0 < 0.6;
    vec4 cloud = vec4(0, 0, 0, 0);

#ifdef DISTANT_HORIZONS
    bool isWater_dh = texture(colortex5, refractedCoord).b > 0.5;

    float z0DH = texture(dhDepthTex0, refractedCoord).x;
    vec3 fragPos = toScreenSpace_alt(refractedCoord, z0, z0DH);

    isWater = (z0 >= 1.0) ? isWater_dh : isWater;

    z0 = (z0 >= 1.0) ? z0DH : z0;
#else

    vec3 fragPos = toScreenSpace(vec3(refractedCoord, z0));

#endif
    vec3 np3 = toWorldSpace(fragPos);

    vec4 color = texture(colortex0, refractedCoord.xy);
#ifdef OVERWORLD
    vec4 sky = texture(colortex8, refractedCoord);
#else
    vec4 sky = vec4(skyFromTex2((np3), colortex6).rgb, 1.0);
#endif
#ifdef CLOUDS

    if (!isHand)
    {
        cloud = renderClouds(blueNoise(gl_FragCoord.xy), np3, sky.rgb, bool(z0 < 1.0), 1, true);

        color.a = cloud.a;

        color.rgb = cloud.rgb;
    }

#endif
    float borderFogFactor = gbf(fragPos, far, 0.0);

    sky.rgb *= clamp(cloud.a, 0, 1);
    sky.rgb += cloud.rgb;
    sky.a = cloud.a;

    sky.rgb = mix(cloud.rgb, sky.rgb, borderFogFactor);

    gl_FragData[0] = vec4(sky);
}
