varying vec2 texcoord;

#include "/lib/sky_function.glsl"
float phaseg(float x, float g)
{
    float gg = g * g;
    return (gg * -0.25 + 0.25) * pow(-2.0 * (g * x) + (gg + 1.0), -1.5) / PI;
}

#if CLOUD_STYLE == 2
    #include "/lib/clouds/clouds_loop_a.glsl"
#else
    #include "/lib/clouds/clouds_bloop.glsl"
#endif

void main()
{
    /* DRAWBUFFERS:8 */

    // unpack NDC
    vec2 ndc = texcoord * 2.0 - 1.0;

    // pre‑compute reciprocal W (only depends on your inverse proj mat)
    float invW = 1.0 / (gbufferProjectionInverse[2][3] + gbufferProjectionInverse[3][3]);

    // reconstruct view‑space position at z = 1
    vec3 p;
    p.x = gbufferProjectionInverse[0][0] * ndc.x + gbufferProjectionInverse[3][0];
    p.y = gbufferProjectionInverse[1][1] * ndc.y + gbufferProjectionInverse[3][1];
    p.z = gbufferProjectionInverse[3][2];

    // transform to world‑space direction & normalize
    vec3 np3 = normalize(mat3(gbufferModelViewInverse) * (p * invW));
    vec4 cloud = vec4(0, 0, 0, 1);

#ifdef OVERWORLD
    vec4 skysample = texture(colortex8, texcoord.xy);
    vec3 color = skysample.rgb;

    #if CLOUD_STYLE == 1
    if (np3.y > 0.0)
    {
    #endif

        float noise = noise_standard(gl_FragCoord.xy);
    #ifndef ALT_CLOUDS
        #if CLOUD_STYLE == 2
        cloud = renderClouds(noise, np3, skysample.rgb, false, 1, true);

        #endif
        #if CLOUD_STYLE == 1
        cloud = renderClouds(noise, np3, skysample.rgb, true);
                // cloud = renderClouds(noise, np3, vec3(0), false);

        #endif
    #else
        cloud = vec4(0, 0, 0, 1);

    #endif
        color *= cloud.a;
     #if CLOUD_STYLE == 1
    }
    else
    {
        cloud.a = 0.0;
    }
    #endif
    color += cloud.rgb;
#else
    #ifdef END

    vec3 altcol = skyFromTex2((np3), colortex6).rgb * 2.0;

    vec3 color = altcol;

        #ifndef ALT_CLOUDS

            #if CLOUD_STYLE == 2
    float noise = noise_standard(gl_FragCoord.xy);

    cloud = renderClouds(noise, np3, altcol.rgb, false, 1, true);

            #endif
            #if CLOUD_STYLE == 1
    cloud = renderClouds(0.0, np3, color, true);

            #endif

    color *= cloud.a * 4.0;

    color *= vec3(1.0, 0.5, 0.3);
        #endif
    #else
    vec3 color = skyFromTex2((np3), colortex6).rgb;

    #endif
#endif
#ifdef SKYBOX_SUPPORT

    //  color = toLinear(texture(colortex8, texcoord.xy).rgb);
#endif
    color.rgb = Dither_Vlachos(color, 1024, gl_FragCoord.xy);

    gl_FragData[0] = vec4(color, cloud.a);
}
