
#include "/lib/ssr/ssr_common.glsl"

vec3 RT_SIMPLE(vec3 dir, vec3 position, float roughness, float dither, float quality)
{
    vec3 rtPos = vec3(1.1);

    vec3 farthestClipPos = toClipSpace3DH(position + dir * 1024);

    if (all(greaterThan(farthestClipPos.xy, vec2(0.0))) && all(lessThan(farthestClipPos.xy, vec2(1.0))))
    {
        float sampledDepth = texture(dhDepthTex0, farthestClipPos.xy).r;
        float currentDepth = (farthestClipPos.z * dhRenderDistance);

        if (sampledDepth < 1.0 && currentDepth <= (sampledDepth * dhRenderDistance) + 0.1)
        {
            //         rtPos = farthestClipPos;
        }
    }
    //  return rtPos;

    vec3 clipPosition = toClipSpace3DH(position);
    vec3 direction = normalize(toClipSpace3DH(position + dir) - clipPosition);
    vec3 maxLengths = (step(0.0, direction) - clipPosition) / direction;

    float mult = min(maxLengths.x, min(maxLengths.y, maxLengths.z));

    vec3 stepv = direction * mult / quality;
    vec3 spos = clipPosition + stepv * dither;

    for (int i = 0; i <= quality; ++i)
    {

        float depthSample = texelFetch2D(dhDepthTex1, ivec2(spos.xy / texelSize), 0).r;

        if (depthSample < spos.z)
        {
            float dist = abs(depthSample - spos.z) / spos.z;
            if (dist <= 0.5)

                rtPos = vec3(spos.xy, depthSample);
            break;
        }
        spos += stepv;
    }

    return rtPos;
}

#include "/lib/specular.glsl"
vec4 mergeSpecularLighting(
    vec3 reflectionColor,
    vec3 rayContrib, // fresnel
    vec3 specTerm,
    vec3 albedo,
    vec3 sunLight,
    vec4 scene,
    float alpha0,
    bool inWater)
{
    vec3 indirectSpecular = reflectionColor * rayContrib;
    vec3 fresnelDiffuse = rayContrib;

    vec3 specularContribution = indirectSpecular + specTerm * sunLight * 2.0;
    vec3 inverseFresnel = 1.0 - fresnelDiffuse;

    float effectiveAlpha = mix(scene.a, 1.0, luma(fresnelDiffuse));

    if (inWater)
        specularContribution *= scene.a;

    vec3 baseColorCorrected = scene.rgb * alpha0 * inverseFresnel;
    vec3 outColor = (specularContribution + inverseFresnel * baseColorCorrected) * albedo;

    return vec4(outColor, effectiveAlpha);
}

vec4 calculateSpecularLightingHQ(
    vec3 normal,
    vec3 np3,
    vec3 albedo,
    float shading,
    float skylight,
    float roughness,
    float porosity,
    vec3 fragpos,
    vec4 scene,
    float alpha0)
{
    bool inWater = (isEyeInWater == 1);
    vec3 reflectionColorScene = scene.rgb;
    bool waterMask = (iswater > 0.99);
    const float f0 = 0.02;

    // Determine the incident and transmitted refractive indices based on the environment
    float etaI = inWater ? 1.33 : 1.0;

    vec3 specTerm = shading * GGX2(normal, -np3, lightPos, WATER_ROUGHNESS, vec3(f0));

    float noise = mix(noise_standard(gl_FragCoord.xy), 0.5, 0.0);
    vec3 L = (reflect(np3, normal));

    vec3 L2 = L;

    float cosThetaI = dot(np3, normal);
    float clampedCosThetaI = clamp(1.0 + cosThetaI, 0.0, 1.0);
    float F = f0 + (1.0 - f0) * pow(clampedCosThetaI, 5.0);

    // Precompute etaI squared
    float etaISq = etaI * etaI;
    float sinThetaTSq = etaISq * (1.0 - cosThetaI * cosThetaI);
    if (sinThetaTSq > 1.0)
    {
        L2.y = -L2.y;
        F = 1.0;
    }
    //  L2.y = mix(L.y, -0.5, clamp(-cosThetaI, 0, 1));
    // L2 = normalize(L2);

    // Geometry term simplified for smooth surfaces with precomputed k
    float NoL = clamp(dot(normal, L), 0.0, 1.0);
    float eps = fwidth(NoL);
    float G1 = NoL / (NoL * 0.99995 + 0.00005 + eps);

    // Calculate the ray's contribution to the final color
    float rayContrib = F * G1;

    vec4 sky = skyFromTex2(L, colortex6);
    sky.rgb = mix(sky.rgb, vec3(sky.a * sunLight), clamp(sky.a, 0, 1));

    vec3 reflectionColor = mix(scene.rgb, sky.rgb, skylight);

    vec3 rtPos = RT_SIMPLE(mat3(gbufferModelView) * L, fragpos, roughness, noise, 32);

    if (rtPos.z < 1.0)

    {
        vec3 previousPosition =
            reprojectDH(mat3(gbufferModelViewInverse) * toScreenSpaceDH(rtPos) + gbufferModelViewInverse[3].xyz, false);
        if (previousPosition.x > 0.0 && previousPosition.y > 0.0 && previousPosition.x < 1.0 && previousPosition.y < 1.0)
        {
            reflectionColor = texture(colortex4, previousPosition.xy).rgb;
        }
    }

    vec4 final = mergeSpecularLighting(reflectionColor, vec3(rayContrib), specTerm, vec3(1.0), sunLight, scene, alpha0, inWater);
    return final;
}

vec4 reflections(float skyLight, vec3 normal, vec3 fragpos, vec4 materialProps, vec4 outcolor, float shading, vec3 albedo, float alpha0)
{

    vec3 p3 = mat3(gbufferModelViewInverse) * fragpos;
    vec3 f0 = vec3(materialProps.z);

    float porosity = 0;

    vec4 reflection = calculateSpecularLightingHQ(normal, normalize(p3), albedo, shading, skyLight, pow(1.0 - materialProps.w, 2.0), porosity, fragpos, outcolor, alpha0);

    return reflection;
}
