/*----------------------------------------------------------------------------------------------
        _____                                                                    _____
        ( ___ )                                                                  ( ___ )
        |   |~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~|   |
        |   | ██╗   ██╗███╗   ██╗██╗███████╗ ██████╗ ██████╗ ███╗   ███╗███████╗ |   |
        |   | ██║   ██║████╗  ██║██║██╔════╝██╔═══██╗██╔══██╗████╗ ████║██╔════╝ |   |
        |   | ██║   ██║██╔██╗ ██║██║█████╗  ██║   ██║██████╔╝██╔████╔██║███████╗ |   |
        |   | ██║   ██║██║╚██╗██║██║██╔══╝  ██║   ██║██╔══██╗██║╚██╔╝██║╚════██║ |   |
        |   | ╚██████╔╝██║ ╚████║██║██║     ╚██████╔╝██║  ██║██║ ╚═╝ ██║███████║ |   |
        |   |  ╚═════╝ ╚═╝  ╚═══╝╚═╝╚═╝      ╚═════╝ ╚═╝  ╚═╝╚═╝     ╚═╝╚══════╝ |   |
        |___|~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~|___|
        (_____)                              (thanks to isuewo and SpacEagle17)  (_____)

---------------------------------------------------------------------------------------------*/
uniform bool isRightHanded = true;
uniform int blockEntityId;

uniform int entityId;
uniform int frameCounter;
uniform int heldBlockLightValue;
uniform int heldBlockLightValue2;
uniform int heldItemId;
uniform int heldItemId2;
uniform int isEyeInWater;
uniform int moonPhase;
uniform int worldTime;
uniform int worldDay;
uniform int bedrockLevel;
uniform int hideGUI;
uniform int renderStage;
uniform float aspectRatio;
uniform float blindness;

uniform float darknessFactor;
uniform float darknessLightFactor;
uniform float maxBlindnessDarkness;
uniform float eyeAltitude;
uniform float frameTime;
uniform float centerDepthSmooth;
#ifdef FROZEN_TIME
float frameTimeCounter = 10;
#else
uniform float frameTimeCounter;
#endif
uniform float far;
uniform float near;
uniform float nightVision;
uniform float rainStrength;
uniform float screenBrightness;
uniform float viewHeight;
uniform float viewWidth;
uniform float wetness;
uniform float sunAngle;

uniform ivec2 atlasSize;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;
uniform vec3 fogColor;
uniform vec3 previousCameraPosition;
uniform vec3 skyColor;
uniform vec3 eyePosition;
uniform vec3 shadowLightPosition;
uniform vec3 playerLookVector;
uniform vec3 upPosition;

uniform vec4 entityColor;
// uniform vec4 lightningBoltPosition = vec4(0);

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 shadowModelView;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowProjectionInverse;
uniform mat4 shadowModelViewProjection;
uniform mat4 modelViewMatrix;
uniform mat4 modelViewMatrixInverse;
uniform mat4 projectionMatrix;
uniform mat4 projectionMatrixInverse;
uniform mat3 normalMatrix;
uniform mat4 textureMatrix;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
uniform sampler2D colortex6;
uniform sampler2D colortex7;
uniform sampler2D colortex8;
uniform sampler2D colortex9;
uniform sampler2D colortex10;
uniform sampler2D colortex11;

uniform sampler2D colortex12;

uniform sampler2D colortex13;

uniform sampler3D colortex15;
uniform sampler2D depthtex0;

uniform sampler2D depthtex1;

uniform sampler2D depthtex2;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux3;
uniform sampler2D gaux4;
uniform sampler2D normals;

uniform sampler2D noisetex;
uniform sampler2D specular;
uniform sampler2D tex;
uniform sampler2D texture;

uniform sampler2D shadowcolor0;
uniform sampler2D shadowcolor1;

uniform sampler2DShadow shadow;
uniform sampler2DShadow shadowtex1;

uniform sampler2D shadowtex0;

#ifdef DISTANT_HORIZONS
uniform int dhRenderDistance;
uniform float dhNearPlane;
uniform float dhFarPlane;
uniform mat4 dhProjection;
uniform mat4 dhProjectionInverse;
uniform mat4 dhPreviousProjection;

uniform sampler2D dhDepthTex;
uniform sampler2D dhDepthTex0;
uniform sampler2D dhDepthTex1;
#endif

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;

#ifdef LPV_ENABLED
uniform usampler1D texBlockData;
uniform sampler3D texLpv1;
uniform sampler3D texLpv2;
uniform int currentRenderedItemId;
#endif
#if defined IS_IRIS
uniform float cloudHeight;
uniform int heightLimit;
uniform float cloudTime;

#else
float cloudTime = frameTimeCounter;

float cloudHeight = 192;
int heightLimit = 320;
#endif

uniform vec2 redPrimary;
uniform vec2 bluePrimary;
uniform vec2 greenPrimary;
uniform vec2 whitePoint;
uniform float maxLuminance;      // absolute
uniform float maxFrameLuminance; // absolute
uniform float minLuminance;      // absolute

/*-----------------------------------------------------------------------------
  ___ _   _ ___ _____ ___  __  __   _   _ _  _ ___ ___ ___  ___ __  __ ___
 / __| | | / __|_   _/ _ \|  \/  | | | | | \| |_ _| __/ _ \| _ \  \/  / __|
| (__| |_| \__ \ | || (_) | |\/| | | |_| | .` || || _| (_) |   / |\/| \__ \
 \___|\___/|___/ |_| \___/|_|  |_|  \___/|_|\_|___|_| \___/|_|_\_|  |_|___/

-----------------------------------------------------------------------------*/

uniform int framemod8;

uniform float velocity;

uniform float sunsetBlend;
uniform float nightblend5Inv;
uniform float nightblend5;
uniform float rainStrengthInv;
uniform float shadowblend;

uniform float sunElevation;
uniform float sunpow;
uniform float lightRadiance;
uniform float nightblendShadows;
uniform float SunsetMult;
uniform float hdrMult;
uniform float hdrMulttorch;

uniform vec2 viewResolution;
uniform vec2 texelSize;
uniform vec3 sunVec;
uniform vec3 sunPosWorld;
uniform vec3 moonPosWorld;

#ifdef OVERWORLD
uniform vec3 sunLight;
uniform vec3 atmosphereUp;

#else
vec3 sunLight = clamp(fogColor * pow(dot(fogColor, vec3(0.299, 0.587, 0.114)), -0.75) * 0.65, 0.0, 1.0) * 0.5;
vec3 atmosphereUp = clamp(fogColor * pow(dot(fogColor, vec3(0.299, 0.587, 0.114)), -0.75) * 0.65, 0.0, 1.0) * 0.5;

#endif

uniform vec3 lightPos;
uniform vec3 shadowPosWorld;

/*-----------------------------------------------------------------------------
MODS
-----------------------------------------------------------------------------*/
