

const vec2 shadowOffsets[6] = vec2[6](vec2(0.5303, 0.5303), vec2(-0.6250, -0.0000), vec2(0.3536, -0.3536),
                                      vec2(-0.0000, 0.3750), vec2(-0.1768, -0.1768), vec2(0.1250, 0.0000));
const float shadowResxDist = 16 / shadowMapResolution * shaddist;

float shadowFunc(float diffuseSun, float sssAmount, vec3 p3, float noise, vec2 lightmap)
{
    float shading = 1.0;
    vec3 ProjShadowPos = (mat3(shadowModelView) * p3) + shadowModelView[3].xyz;

    ProjShadowPos = vec3(ProjShadowPos.x * shadowProjection[0].x + shadowProjection[3].x,
                         ProjShadowPos.y * shadowProjection[1].y + shadowProjection[3].y,
                         ProjShadowPos.z * shadowProjection[2].z + shadowProjection[3].z);

    float distortFac = calcDistort(ProjShadowPos.xy);

    ProjShadowPos.xy *= distortFac;
    vec2 bounds = vec2(1.0, 1.0) - 1.5 / shadowMapResolution;
    if (all(lessThan(abs(ProjShadowPos.xy), bounds)) && abs(ProjShadowPos.z) < 6)
    {

        shading = 0.0;
        ProjShadowPos = ProjShadowPos * vec3(0.5, 0.5, 0.0833333333333333) + 0.5;
        diffuseSun = mix(diffuseSun, 0.5, sssAmount);
        float scaleFac = 1.0 / (1 * 6000.0);

        float term1 = (sqrt(1.0 - diffuseSun * diffuseSun) / diffuseSun) * scaleFac;

        float diffthresh = term1 * max(shadowResxDist, 0.95);

        float weight = 1.0 + noise * shadowMapResolution * 0.00016;
        float dweight = -diffthresh * weight;
        float noise2 = noise * 0.0005;

        vec3 shadowCoordWeighted = ProjShadowPos + vec3(noise2, noise2, dweight);

        shading += texture(shadow, shadowCoordWeighted);

        shading *= 0.1666;

        shading = mix(1.0, shading, nightblendShadows);
    }

    return diffuseSun * shading;
}
