/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;

public class UnicodeGlyphButton
extends ExtendedButton {
    public String glyph;
    public float glyphScale;

    public UnicodeGlyphButton(int xPos, int yPos, int width, int height, Component displayString, String glyph, float glyphScale, Button.OnPress handler) {
        super(xPos, yPos, width, height, displayString, handler);
        this.glyph = glyph;
        this.glyphScale = glyphScale;
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        MutableComponent buttonText = this.createNarrationMessage();
        int glyphWidth = (int)((float)mc.font.width(this.glyph) * this.glyphScale);
        int strWidth = mc.font.width((FormattedText)buttonText);
        int ellipsisWidth = mc.font.width("...");
        int totalWidth = strWidth + glyphWidth;
        if (totalWidth > this.width - 6 && totalWidth > ellipsisWidth) {
            buttonText = Component.literal((String)(mc.font.substrByWidth((FormattedText)buttonText, this.width - 6 - ellipsisWidth).getString().trim() + "..."));
        }
        strWidth = mc.font.width((FormattedText)buttonText);
        totalWidth = glyphWidth + strWidth;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(this.glyphScale, this.glyphScale, 1.0f);
        guiGraphics.drawCenteredString(mc.font, (Component)Component.literal((String)this.glyph), (int)((float)(this.getX() + this.width / 2 - strWidth / 2) / this.glyphScale - (float)glyphWidth / (2.0f * this.glyphScale) + 2.0f), (int)(((float)this.getY() + (float)(this.height - 8) / this.glyphScale / 2.0f - 1.0f) / this.glyphScale), this.getFGColor());
        guiGraphics.pose().popPose();
        guiGraphics.drawCenteredString(mc.font, (Component)buttonText, (int)((float)(this.getX() + this.width / 2) + (float)glyphWidth / this.glyphScale), this.getY() + (this.height - 8) / 2, this.getFGColor());
    }
}

