/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentCopyHandler;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;

@EventBusSubscriber(modid="neoforge")
@ApiStatus.Internal
public final class AttachmentInternals {
    private static <H extends AttachmentHolder> void copyAttachments(HolderLookup.Provider provider, H from, H to, Predicate<AttachmentType<?>> filter) {
        if (from.attachments == null) {
            return;
        }
        for (Map.Entry<AttachmentType<?>, Object> entry : from.attachments.entrySet()) {
            Object copy;
            AttachmentType<?> type = entry.getKey();
            if (type.serializer == null) continue;
            IAttachmentCopyHandler<Object> copyHandler = type.copyHandler;
            if (!filter.test(type) || (copy = copyHandler.copy(entry.getValue(), to.getExposedHolder(), provider)) == null) continue;
            to.getAttachmentMap().put(type, copy);
        }
    }

    public static void copyChunkAttachmentsOnPromotion(HolderLookup.Provider provider, AttachmentHolder.AsField from, AttachmentHolder.AsField to) {
        AttachmentInternals.copyAttachments(provider, from, to, type -> true);
    }

    public static void copyEntityAttachments(Entity from, Entity to, boolean isDeath) {
        AttachmentInternals.copyAttachments((HolderLookup.Provider)from.registryAccess(), from, to, isDeath ? type -> type.copyOnDeath : type -> true);
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        event.getEntity().copyAttachmentsFrom((Entity)event.getOriginal(), event.isWasDeath());
    }

    @SubscribeEvent
    public static void onLivingConvert(LivingConversionEvent.Post event) {
        event.getOutcome().copyAttachmentsFrom((Entity)event.getEntity(), true);
    }

    private AttachmentInternals() {
    }
}

