/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public class ListTag
extends CollectionTag<Tag> {
    private static final int SELF_SIZE_IN_BYTES = 37;
    public static final TagType<ListTag> TYPE = new TagType.VariableSize<ListTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListTag load(DataInput p_128792_, NbtAccounter p_128794_) throws IOException {
            ListTag listtag;
            p_128794_.pushDepth();
            try {
                listtag = 1.loadList(p_128792_, p_128794_);
            }
            finally {
                p_128794_.popDepth();
            }
            return listtag;
        }

        private static ListTag loadList(DataInput p_302382_, NbtAccounter p_302349_) throws IOException {
            p_302349_.accountBytes(37L);
            byte b0 = p_302382_.readByte();
            int i = p_302382_.readInt();
            if (b0 == 0 && i > 0) {
                throw new NbtFormatException("Missing type on ListTag");
            }
            p_302349_.accountBytes(4L, i);
            TagType tagtype = TagTypes.getType((int)b0);
            ArrayList list = Lists.newArrayListWithCapacity((int)i);
            for (int j = 0; j < i; ++j) {
                list.add(tagtype.load(p_302382_, p_302349_));
            }
            return new ListTag(list, b0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StreamTagVisitor.ValueResult parse(DataInput p_197491_, StreamTagVisitor p_197492_, NbtAccounter p_302333_) throws IOException {
            StreamTagVisitor.ValueResult streamtagvisitor$valueresult;
            p_302333_.pushDepth();
            try {
                streamtagvisitor$valueresult = 1.parseList(p_197491_, p_197492_, p_302333_);
            }
            finally {
                p_302333_.popDepth();
            }
            return streamtagvisitor$valueresult;
        }

        private static StreamTagVisitor.ValueResult parseList(DataInput p_302369_, StreamTagVisitor p_302372_, NbtAccounter p_302361_) throws IOException {
            p_302361_.accountBytes(37L);
            TagType tagtype = TagTypes.getType((int)p_302369_.readByte());
            int i = p_302369_.readInt();
            switch (p_302372_.visitList(tagtype, i)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    tagtype.skip(p_302369_, i, p_302361_);
                    return p_302372_.visitContainerEnd();
                }
            }
            p_302361_.accountBytes(4L, i);
            int j = 0;
            while (true) {
                block16: {
                    int k;
                    block15: {
                        if (j >= i) break block15;
                        block4 : switch (p_302372_.visitElement(tagtype, j)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                            case BREAK: {
                                tagtype.skip(p_302369_, p_302361_);
                                break;
                            }
                            case SKIP: {
                                tagtype.skip(p_302369_, p_302361_);
                                break block16;
                            }
                            default: {
                                switch (tagtype.parse(p_302369_, p_302372_, p_302361_)) {
                                    case HALT: {
                                        return StreamTagVisitor.ValueResult.HALT;
                                    }
                                    case BREAK: {
                                        break block4;
                                    }
                                }
                                break block16;
                            }
                        }
                    }
                    if ((k = i - 1 - j) > 0) {
                        tagtype.skip(p_302369_, k, p_302361_);
                    }
                    return p_302372_.visitContainerEnd();
                }
                ++j;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void skip(DataInput p_302400_, NbtAccounter p_302390_) throws IOException {
            p_302390_.pushDepth();
            try {
                TagType tagtype = TagTypes.getType((int)p_302400_.readByte());
                int i = p_302400_.readInt();
                tagtype.skip(p_302400_, i, p_302390_);
            }
            finally {
                p_302390_.popDepth();
            }
        }

        public String getName() {
            return "LIST";
        }

        public String getPrettyName() {
            return "TAG_List";
        }
    };
    private final List<Tag> list;
    private byte type;

    ListTag(List<Tag> p_128721_, byte p_128722_) {
        this.list = p_128721_;
        this.type = p_128722_;
    }

    public ListTag() {
        this(Lists.newArrayList(), 0);
    }

    public ListTag(int initialCapacity) {
        this(new ArrayList<Tag>(initialCapacity), 0);
    }

    public void write(DataOutput p_128734_) throws IOException {
        this.type = this.list.isEmpty() ? (byte)0 : this.list.get(0).getId();
        p_128734_.writeByte(this.type);
        p_128734_.writeInt(this.list.size());
        for (Tag tag : this.list) {
            tag.write(p_128734_);
        }
    }

    public int sizeInBytes() {
        int i = 37;
        i += 4 * this.list.size();
        for (Tag tag : this.list) {
            i += tag.sizeInBytes();
        }
        return i;
    }

    public byte getId() {
        return 9;
    }

    public TagType<ListTag> getType() {
        return TYPE;
    }

    public String toString() {
        return this.getAsString();
    }

    private void updateTypeAfterRemove() {
        if (this.list.isEmpty()) {
            this.type = 0;
        }
    }

    public Tag remove(int p_128751_) {
        Tag tag = this.list.remove(p_128751_);
        this.updateTypeAfterRemove();
        return tag;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public CompoundTag getCompound(int p_128729_) {
        Tag tag;
        if (p_128729_ >= 0 && p_128729_ < this.list.size() && (tag = this.list.get(p_128729_)).getId() == 10) {
            return (CompoundTag)tag;
        }
        return new CompoundTag();
    }

    public ListTag getList(int p_128745_) {
        Tag tag;
        if (p_128745_ >= 0 && p_128745_ < this.list.size() && (tag = this.list.get(p_128745_)).getId() == 9) {
            return (ListTag)tag;
        }
        return new ListTag();
    }

    public short getShort(int p_128758_) {
        Tag tag;
        if (p_128758_ >= 0 && p_128758_ < this.list.size() && (tag = this.list.get(p_128758_)).getId() == 2) {
            return ((ShortTag)tag).getAsShort();
        }
        return 0;
    }

    public int getInt(int p_128764_) {
        Tag tag;
        if (p_128764_ >= 0 && p_128764_ < this.list.size() && (tag = this.list.get(p_128764_)).getId() == 3) {
            return ((IntTag)tag).getAsInt();
        }
        return 0;
    }

    public int[] getIntArray(int p_128768_) {
        Tag tag;
        if (p_128768_ >= 0 && p_128768_ < this.list.size() && (tag = this.list.get(p_128768_)).getId() == 11) {
            return ((IntArrayTag)tag).getAsIntArray();
        }
        return new int[0];
    }

    public long[] getLongArray(int p_177992_) {
        Tag tag;
        if (p_177992_ >= 0 && p_177992_ < this.list.size() && (tag = this.list.get(p_177992_)).getId() == 12) {
            return ((LongArrayTag)tag).getAsLongArray();
        }
        return new long[0];
    }

    public double getDouble(int p_128773_) {
        Tag tag;
        if (p_128773_ >= 0 && p_128773_ < this.list.size() && (tag = this.list.get(p_128773_)).getId() == 6) {
            return ((DoubleTag)tag).getAsDouble();
        }
        return 0.0;
    }

    public float getFloat(int p_128776_) {
        Tag tag;
        if (p_128776_ >= 0 && p_128776_ < this.list.size() && (tag = this.list.get(p_128776_)).getId() == 5) {
            return ((FloatTag)tag).getAsFloat();
        }
        return 0.0f;
    }

    public String getString(int p_128779_) {
        if (p_128779_ >= 0 && p_128779_ < this.list.size()) {
            Tag tag = this.list.get(p_128779_);
            return tag.getId() == 8 ? tag.getAsString() : tag.toString();
        }
        return "";
    }

    public int size() {
        return this.list.size();
    }

    public Tag get(int p_128781_) {
        return this.list.get(p_128781_);
    }

    public Tag set(int p_128760_, Tag p_128761_) {
        Tag tag = this.get(p_128760_);
        if (!this.setTag(p_128760_, p_128761_)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", p_128761_.getId(), this.type));
        }
        return tag;
    }

    public void add(int p_128753_, Tag p_128754_) {
        if (!this.addTag(p_128753_, p_128754_)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", p_128754_.getId(), this.type));
        }
    }

    public boolean setTag(int p_128731_, Tag p_128732_) {
        if (this.updateType(p_128732_)) {
            this.list.set(p_128731_, p_128732_);
            return true;
        }
        return false;
    }

    public boolean addTag(int p_128747_, Tag p_128748_) {
        if (this.updateType(p_128748_)) {
            this.list.add(p_128747_, p_128748_);
            return true;
        }
        return false;
    }

    private boolean updateType(Tag p_128739_) {
        if (p_128739_.getId() == 0) {
            return false;
        }
        if (this.type == 0) {
            this.type = p_128739_.getId();
            return true;
        }
        return this.type == p_128739_.getId();
    }

    public ListTag copy() {
        List<Tag> iterable = TagTypes.getType((int)this.type).isValue() ? this.list : Iterables.transform(this.list, Tag::copy);
        ArrayList list = Lists.newArrayList(iterable);
        return new ListTag(list, this.type);
    }

    public boolean equals(Object p_128766_) {
        return this == p_128766_ ? true : p_128766_ instanceof ListTag && Objects.equals(this.list, ((ListTag)((Object)p_128766_)).list);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public void accept(TagVisitor p_177990_) {
        p_177990_.visitList(this);
    }

    public byte getElementType() {
        return this.type;
    }

    public void clear() {
        this.list.clear();
        this.type = 0;
    }

    public StreamTagVisitor.ValueResult accept(StreamTagVisitor p_197487_) {
        switch (p_197487_.visitList(TagTypes.getType((int)this.type), this.list.size())) {
            case HALT: {
                return StreamTagVisitor.ValueResult.HALT;
            }
            case BREAK: {
                return p_197487_.visitContainerEnd();
            }
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Tag tag = this.list.get(i);
            switch (p_197487_.visitElement(tag.getType(), i)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return p_197487_.visitContainerEnd();
                }
                default: {
                    switch (tag.accept(p_197487_)) {
                        case HALT: {
                            return StreamTagVisitor.ValueResult.HALT;
                        }
                        case BREAK: {
                            return p_197487_.visitContainerEnd();
                        }
                    }
                }
                case SKIP: 
            }
        }
        return p_197487_.visitContainerEnd();
    }
}

