/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import java.util.Optional;
import java.util.function.Supplier;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.Nullable;

public interface IAttachmentHolder {
    public boolean hasAttachments();

    public boolean hasData(AttachmentType<?> var1);

    default public <T> boolean hasData(Supplier<AttachmentType<T>> type) {
        return this.hasData(type.get());
    }

    public <T> T getData(AttachmentType<T> var1);

    default public <T> T getData(Supplier<AttachmentType<T>> type) {
        return this.getData(type.get());
    }

    default public <T> Optional<T> getExistingData(AttachmentType<T> type) {
        return Optional.ofNullable(this.getExistingDataOrNull(type));
    }

    default public <T> Optional<T> getExistingData(Supplier<AttachmentType<T>> type) {
        return this.getExistingData(type.get());
    }

    @Nullable
    default public <T> T getExistingDataOrNull(AttachmentType<T> type) {
        return this.getExistingData(type).orElse(null);
    }

    @Nullable
    default public <T> T getExistingDataOrNull(Supplier<AttachmentType<T>> type) {
        return this.getExistingDataOrNull(type.get());
    }

    @Nullable
    public <T> T setData(AttachmentType<T> var1, T var2);

    @Nullable
    default public <T> T setData(Supplier<AttachmentType<T>> type, T data) {
        return this.setData(type.get(), data);
    }

    @Nullable
    public <T> T removeData(AttachmentType<T> var1);

    @Nullable
    default public <T> T removeData(Supplier<AttachmentType<T>> type) {
        return this.removeData(type.get());
    }
}

