/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;

public class ComparatorBlock
extends DiodeBlock
implements EntityBlock {
    public static final MapCodec<ComparatorBlock> CODEC = ComparatorBlock.simpleCodec(ComparatorBlock::new);
    public static final EnumProperty<ComparatorMode> MODE = BlockStateProperties.MODE_COMPARATOR;

    public MapCodec<ComparatorBlock> codec() {
        return CODEC;
    }

    public ComparatorBlock(BlockBehaviour.Properties p_51857_) {
        super(p_51857_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(MODE, ComparatorMode.COMPARE));
    }

    @Override
    protected int getDelay(BlockState p_51912_) {
        return 2;
    }

    @Override
    public BlockState updateShape(BlockState p_301069_, Direction p_301249_, BlockState p_301318_, LevelAccessor p_301207_, BlockPos p_301025_, BlockPos p_301045_) {
        if (p_301249_ == Direction.DOWN && !this.canSurviveOn(p_301207_, p_301045_, p_301318_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_301069_, p_301249_, p_301318_, p_301207_, p_301025_, p_301045_);
    }

    @Override
    protected int getOutputSignal(BlockGetter p_51892_, BlockPos p_51893_, BlockState p_51894_) {
        BlockEntity $$3 = p_51892_.getBlockEntity(p_51893_);
        if ($$3 instanceof ComparatorBlockEntity) {
            return ((ComparatorBlockEntity)$$3).getOutputSignal();
        }
        return 0;
    }

    private int calculateOutputSignal(Level p_51904_, BlockPos p_51905_, BlockState p_51906_) {
        int $$3 = this.getInputSignal(p_51904_, p_51905_, p_51906_);
        if ($$3 == 0) {
            return 0;
        }
        int $$4 = this.getAlternateSignal(p_51904_, p_51905_, p_51906_);
        if ($$4 > $$3) {
            return 0;
        }
        if (p_51906_.getValue(MODE) == ComparatorMode.SUBTRACT) {
            return $$3 - $$4;
        }
        return $$3;
    }

    @Override
    protected boolean shouldTurnOn(Level p_51861_, BlockPos p_51862_, BlockState p_51863_) {
        int $$3 = this.getInputSignal(p_51861_, p_51862_, p_51863_);
        if ($$3 == 0) {
            return false;
        }
        int $$4 = this.getAlternateSignal(p_51861_, p_51862_, p_51863_);
        if ($$3 > $$4) {
            return true;
        }
        return $$3 == $$4 && p_51863_.getValue(MODE) == ComparatorMode.COMPARE;
    }

    @Override
    protected int getInputSignal(Level p_51896_, BlockPos p_51897_, BlockState p_51898_) {
        int $$3 = super.getInputSignal(p_51896_, p_51897_, p_51898_);
        Direction $$4 = p_51898_.getValue(FACING);
        BlockPos $$5 = p_51897_.relative($$4);
        BlockState $$6 = p_51896_.getBlockState($$5);
        if ($$6.hasAnalogOutputSignal()) {
            $$3 = $$6.getAnalogOutputSignal(p_51896_, $$5);
        } else if ($$3 < 15 && $$6.isRedstoneConductor(p_51896_, $$5)) {
            $$5 = $$5.relative($$4);
            $$6 = p_51896_.getBlockState($$5);
            ItemFrame $$7 = this.getItemFrame(p_51896_, $$4, $$5);
            int $$8 = Math.max($$7 == null ? Integer.MIN_VALUE : $$7.getAnalogOutput(), $$6.hasAnalogOutputSignal() ? $$6.getAnalogOutputSignal(p_51896_, $$5) : Integer.MIN_VALUE);
            if ($$8 != Integer.MIN_VALUE) {
                $$3 = $$8;
            }
        }
        return $$3;
    }

    @Nullable
    private ItemFrame getItemFrame(Level p_51865_, Direction p_51866_, BlockPos p_51867_) {
        List<ItemFrame> $$3 = p_51865_.getEntitiesOfClass(ItemFrame.class, new AABB(p_51867_.getX(), p_51867_.getY(), p_51867_.getZ(), p_51867_.getX() + 1, p_51867_.getY() + 1, p_51867_.getZ() + 1), p_352876_ -> p_352876_ != null && p_352876_.getDirection() == p_51866_);
        if ($$3.size() == 1) {
            return $$3.get(0);
        }
        return null;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_51880_, Level p_51881_, BlockPos p_51882_, Player p_51883_, BlockHitResult p_51885_) {
        if (!p_51883_.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        float $$5 = (p_51880_ = (BlockState)p_51880_.cycle(MODE)).getValue(MODE) == ComparatorMode.SUBTRACT ? 0.55f : 0.5f;
        p_51881_.playSound(p_51883_, p_51882_, SoundEvents.COMPARATOR_CLICK, SoundSource.BLOCKS, 0.3f, $$5);
        p_51881_.setBlock(p_51882_, p_51880_, 2);
        this.refreshOutputState(p_51881_, p_51882_, p_51880_);
        return InteractionResult.sidedSuccess(p_51881_.isClientSide);
    }

    @Override
    protected void checkTickOnNeighbor(Level p_51900_, BlockPos p_51901_, BlockState p_51902_) {
        int $$5;
        if (p_51900_.getBlockTicks().willTickThisTick(p_51901_, this)) {
            return;
        }
        int $$3 = this.calculateOutputSignal(p_51900_, p_51901_, p_51902_);
        BlockEntity $$4 = p_51900_.getBlockEntity(p_51901_);
        int n = $$5 = $$4 instanceof ComparatorBlockEntity ? ((ComparatorBlockEntity)$$4).getOutputSignal() : 0;
        if ($$3 != $$5 || p_51902_.getValue(POWERED).booleanValue() != this.shouldTurnOn(p_51900_, p_51901_, p_51902_)) {
            TickPriority $$6 = this.shouldPrioritize(p_51900_, p_51901_, p_51902_) ? TickPriority.HIGH : TickPriority.NORMAL;
            p_51900_.scheduleTick(p_51901_, this, 2, $$6);
        }
    }

    private void refreshOutputState(Level p_51908_, BlockPos p_51909_, BlockState p_51910_) {
        int $$3 = this.calculateOutputSignal(p_51908_, p_51909_, p_51910_);
        BlockEntity $$4 = p_51908_.getBlockEntity(p_51909_);
        int $$5 = 0;
        if ($$4 instanceof ComparatorBlockEntity) {
            ComparatorBlockEntity $$6 = (ComparatorBlockEntity)$$4;
            $$5 = $$6.getOutputSignal();
            $$6.setOutputSignal($$3);
        }
        if ($$5 != $$3 || p_51910_.getValue(MODE) == ComparatorMode.COMPARE) {
            boolean $$7 = this.shouldTurnOn(p_51908_, p_51909_, p_51910_);
            boolean $$8 = p_51910_.getValue(POWERED);
            if ($$8 && !$$7) {
                p_51908_.setBlock(p_51909_, (BlockState)p_51910_.setValue(POWERED, false), 2);
            } else if (!$$8 && $$7) {
                p_51908_.setBlock(p_51909_, (BlockState)p_51910_.setValue(POWERED, true), 2);
            }
            this.updateNeighborsInFront(p_51908_, p_51909_, p_51910_);
        }
    }

    @Override
    protected void tick(BlockState p_221010_, ServerLevel p_221011_, BlockPos p_221012_, RandomSource p_221013_) {
        this.refreshOutputState(p_221011_, p_221012_, p_221010_);
    }

    @Override
    protected boolean triggerEvent(BlockState p_51874_, Level p_51875_, BlockPos p_51876_, int p_51877_, int p_51878_) {
        super.triggerEvent(p_51874_, p_51875_, p_51876_, p_51877_, p_51878_);
        BlockEntity $$5 = p_51875_.getBlockEntity(p_51876_);
        return $$5 != null && $$5.triggerEvent(p_51877_, p_51878_);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_153086_, BlockState p_153087_) {
        return new ComparatorBlockEntity(p_153086_, p_153087_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_51887_) {
        p_51887_.add(FACING, MODE, POWERED);
    }
}

