/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.AllOf;
import net.minecraft.world.item.enchantment.effects.ApplyMobEffect;
import net.minecraft.world.item.enchantment.effects.DamageEntity;
import net.minecraft.world.item.enchantment.effects.DamageItem;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.item.enchantment.effects.ExplodeEffect;
import net.minecraft.world.item.enchantment.effects.Ignite;
import net.minecraft.world.item.enchantment.effects.PlaySoundEffect;
import net.minecraft.world.item.enchantment.effects.ReplaceBlock;
import net.minecraft.world.item.enchantment.effects.ReplaceDisk;
import net.minecraft.world.item.enchantment.effects.RunFunction;
import net.minecraft.world.item.enchantment.effects.SetBlockProperties;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.item.enchantment.effects.SummonEntityEffect;
import net.minecraft.world.phys.Vec3;

public interface EnchantmentLocationBasedEffect {
    public static final Codec<EnchantmentLocationBasedEffect> CODEC = BuiltInRegistries.ENCHANTMENT_LOCATION_BASED_EFFECT_TYPE.byNameCodec().dispatch(EnchantmentLocationBasedEffect::codec, Function.identity());

    public static MapCodec<? extends EnchantmentLocationBasedEffect> bootstrap(Registry<MapCodec<? extends EnchantmentLocationBasedEffect>> p_344955_) {
        Registry.register(p_344955_, "all_of", AllOf.LocationBasedEffects.CODEC);
        Registry.register(p_344955_, "apply_mob_effect", ApplyMobEffect.CODEC);
        Registry.register(p_344955_, "attribute", EnchantmentAttributeEffect.CODEC);
        Registry.register(p_344955_, "damage_entity", DamageEntity.CODEC);
        Registry.register(p_344955_, "damage_item", DamageItem.CODEC);
        Registry.register(p_344955_, "explode", ExplodeEffect.CODEC);
        Registry.register(p_344955_, "ignite", Ignite.CODEC);
        Registry.register(p_344955_, "play_sound", PlaySoundEffect.CODEC);
        Registry.register(p_344955_, "replace_block", ReplaceBlock.CODEC);
        Registry.register(p_344955_, "replace_disk", ReplaceDisk.CODEC);
        Registry.register(p_344955_, "run_function", RunFunction.CODEC);
        Registry.register(p_344955_, "set_block_properties", SetBlockProperties.CODEC);
        Registry.register(p_344955_, "spawn_particles", SpawnParticlesEffect.CODEC);
        return Registry.register(p_344955_, "summon_entity", SummonEntityEffect.CODEC);
    }

    public void onChangedBlock(ServerLevel var1, int var2, EnchantedItemInUse var3, Entity var4, Vec3 var5, boolean var6);

    default public void onDeactivated(EnchantedItemInUse p_346131_, Entity p_345920_, Vec3 p_345758_, int p_344750_) {
    }

    public MapCodec<? extends EnchantmentLocationBasedEffect> codec();
}

