/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;

public class Digging<E extends Warden>
extends Behavior<E> {
    public Digging(int p_217515_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), p_217515_);
    }

    @Override
    protected boolean canStillUse(ServerLevel p_217527_, E p_217528_, long p_217529_) {
        return ((Entity)p_217528_).getRemovalReason() == null;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel p_217524_, E p_217525_) {
        return ((Entity)p_217525_).onGround() || ((Entity)p_217525_).isInWater() || ((Entity)p_217525_).isInLava();
    }

    @Override
    protected void start(ServerLevel p_217535_, E p_217536_, long p_217537_) {
        if (((Entity)p_217536_).onGround()) {
            ((Entity)p_217536_).setPose(Pose.DIGGING);
            ((Entity)p_217536_).playSound(SoundEvents.WARDEN_DIG, 5.0f, 1.0f);
        } else {
            ((Entity)p_217536_).playSound(SoundEvents.WARDEN_AGITATED, 5.0f, 1.0f);
            this.stop(p_217535_, p_217536_, p_217537_);
        }
    }

    @Override
    protected void stop(ServerLevel p_217543_, E p_217544_, long p_217545_) {
        if (((Entity)p_217544_).getRemovalReason() == null) {
            ((LivingEntity)p_217544_).remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (E)((Warden)livingEntity), l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (E)((Warden)livingEntity), l);
    }
}

