/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;

public class FallbackResourceManager
implements ResourceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    protected final List<PackEntry> fallbacks = Lists.newArrayList();
    private final PackType type;
    private final String namespace;

    public FallbackResourceManager(PackType p_10605_, String p_10606_) {
        this.type = p_10605_;
        this.namespace = p_10606_;
    }

    public void push(PackResources p_215378_) {
        this.pushInternal(p_215378_.packId(), p_215378_, null);
    }

    public void push(PackResources p_215383_, Predicate<ResourceLocation> p_215384_) {
        this.pushInternal(p_215383_.packId(), p_215383_, p_215384_);
    }

    public void pushFilterOnly(String p_215400_, Predicate<ResourceLocation> p_215401_) {
        this.pushInternal(p_215400_, null, p_215401_);
    }

    private void pushInternal(String p_215396_, @Nullable PackResources p_215397_, @Nullable Predicate<ResourceLocation> p_215398_) {
        this.fallbacks.add(new PackEntry(p_215396_, p_215397_, p_215398_));
    }

    @Override
    public Set<String> getNamespaces() {
        return ImmutableSet.of((Object)this.namespace);
    }

    @Override
    public Optional<Resource> getResource(ResourceLocation p_215419_) {
        for (int $$1 = this.fallbacks.size() - 1; $$1 >= 0; --$$1) {
            IoSupplier<InputStream> $$4;
            PackEntry $$2 = this.fallbacks.get($$1);
            PackResources $$3 = $$2.resources;
            if ($$3 != null && ($$4 = $$3.getResource(this.type, p_215419_)) != null) {
                IoSupplier<ResourceMetadata> $$5 = this.createStackMetadataFinder(p_215419_, $$1);
                return Optional.of(FallbackResourceManager.createResource($$3, p_215419_, $$4, $$5));
            }
            if (!$$2.isFiltered(p_215419_)) continue;
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)p_215419_, (Object)$$2.name);
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static Resource createResource(PackResources p_249946_, ResourceLocation p_250632_, IoSupplier<InputStream> p_250514_, IoSupplier<ResourceMetadata> p_251676_) {
        return new Resource(p_249946_, FallbackResourceManager.wrapForDebug(p_250632_, p_249946_, p_250514_), p_251676_);
    }

    private static IoSupplier<InputStream> wrapForDebug(ResourceLocation p_248639_, PackResources p_251740_, IoSupplier<InputStream> p_249116_) {
        if (LOGGER.isDebugEnabled()) {
            return () -> new LeakedResourceWarningInputStream((InputStream)p_249116_.get(), p_248639_, p_251740_.packId());
        }
        return p_249116_;
    }

    @Override
    public List<Resource> getResourceStack(ResourceLocation p_215367_) {
        ResourceLocation $$1 = FallbackResourceManager.getMetadataLocation(p_215367_);
        ArrayList<Resource> $$2 = new ArrayList<Resource>();
        boolean $$3 = false;
        String $$4 = null;
        for (int $$5 = this.fallbacks.size() - 1; $$5 >= 0; --$$5) {
            IoSupplier<InputStream> $$8;
            PackEntry $$6 = this.fallbacks.get($$5);
            PackResources $$7 = $$6.resources;
            if ($$7 != null && ($$8 = $$7.getResource(this.type, p_215367_)) != null) {
                IoSupplier<ResourceMetadata> $$10;
                if ($$3) {
                    IoSupplier<ResourceMetadata> $$9 = ResourceMetadata.EMPTY_SUPPLIER;
                } else {
                    $$10 = () -> {
                        IoSupplier<InputStream> $$2 = $$7.getResource(this.type, $$1);
                        return $$2 != null ? FallbackResourceManager.parseMetadata($$2) : ResourceMetadata.EMPTY;
                    };
                }
                $$2.add(new Resource($$7, $$8, $$10));
            }
            if ($$6.isFiltered(p_215367_)) {
                $$4 = $$6.name;
                break;
            }
            if (!$$6.isFiltered($$1)) continue;
            $$3 = true;
        }
        if ($$2.isEmpty() && $$4 != null) {
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)p_215367_, $$4);
        }
        return Lists.reverse($$2);
    }

    private static boolean isMetadata(ResourceLocation p_249381_) {
        return p_249381_.getPath().endsWith(".mcmeta");
    }

    private static ResourceLocation getResourceLocationFromMetadata(ResourceLocation p_249669_) {
        String $$1 = p_249669_.getPath().substring(0, p_249669_.getPath().length() - ".mcmeta".length());
        return p_249669_.withPath($$1);
    }

    static ResourceLocation getMetadataLocation(ResourceLocation p_10625_) {
        return p_10625_.withPath(p_10625_.getPath() + ".mcmeta");
    }

    @Override
    public Map<ResourceLocation, Resource> listResources(String p_215413_, Predicate<ResourceLocation> p_215414_) {
        record ResourceWithSourceAndIndex(PackResources packResources, IoSupplier<InputStream> resource, int packIndex) {
        }
        HashMap<ResourceLocation, ResourceWithSourceAndIndex> $$2 = new HashMap<ResourceLocation, ResourceWithSourceAndIndex>();
        HashMap $$3 = new HashMap();
        int $$4 = this.fallbacks.size();
        for (int $$5 = 0; $$5 < $$4; ++$$5) {
            PackEntry $$6 = this.fallbacks.get($$5);
            $$6.filterAll($$2.keySet());
            $$6.filterAll($$3.keySet());
            PackResources $$7 = $$6.resources;
            if ($$7 == null) continue;
            int $$8 = $$5;
            $$7.listResources(this.type, this.namespace, p_215413_, (p_248254_, p_248255_) -> {
                if (FallbackResourceManager.isMetadata(p_248254_)) {
                    if (p_215414_.test(FallbackResourceManager.getResourceLocationFromMetadata(p_248254_))) {
                        $$3.put(p_248254_, new ResourceWithSourceAndIndex($$7, (IoSupplier<InputStream>)p_248255_, $$8));
                    }
                } else if (p_215414_.test((ResourceLocation)p_248254_)) {
                    $$2.put((ResourceLocation)p_248254_, new ResourceWithSourceAndIndex($$7, (IoSupplier<InputStream>)p_248255_, $$8));
                }
            });
        }
        TreeMap $$9 = Maps.newTreeMap();
        $$2.forEach((p_248258_, p_248259_) -> {
            IoSupplier<ResourceMetadata> $$7;
            ResourceLocation $$4 = FallbackResourceManager.getMetadataLocation(p_248258_);
            ResourceWithSourceAndIndex $$5 = (ResourceWithSourceAndIndex)$$3.get($$4);
            if ($$5 != null && $$5.packIndex >= p_248259_.packIndex) {
                IoSupplier<ResourceMetadata> $$6 = FallbackResourceManager.convertToMetadata($$5.resource);
            } else {
                $$7 = ResourceMetadata.EMPTY_SUPPLIER;
            }
            $$9.put(p_248258_, FallbackResourceManager.createResource(p_248259_.packResources, p_248258_, p_248259_.resource, $$7));
        });
        return $$9;
    }

    private IoSupplier<ResourceMetadata> createStackMetadataFinder(ResourceLocation p_215369_, int p_215370_) {
        return () -> {
            ResourceLocation $$2 = FallbackResourceManager.getMetadataLocation(p_215369_);
            for (int $$3 = this.fallbacks.size() - 1; $$3 >= p_215370_; --$$3) {
                IoSupplier<InputStream> $$6;
                PackEntry $$4 = this.fallbacks.get($$3);
                PackResources $$5 = $$4.resources;
                if ($$5 != null && ($$6 = $$5.getResource(this.type, $$2)) != null) {
                    return FallbackResourceManager.parseMetadata($$6);
                }
                if ($$4.isFiltered($$2)) break;
            }
            return ResourceMetadata.EMPTY;
        };
    }

    private static IoSupplier<ResourceMetadata> convertToMetadata(IoSupplier<InputStream> p_250827_) {
        return () -> FallbackResourceManager.parseMetadata(p_250827_);
    }

    private static ResourceMetadata parseMetadata(IoSupplier<InputStream> p_250103_) throws IOException {
        try (InputStream $$1 = p_250103_.get();){
            ResourceMetadata resourceMetadata = ResourceMetadata.fromJsonStream($$1);
            return resourceMetadata;
        }
    }

    private static void applyPackFiltersToExistingResources(PackEntry p_215393_, Map<ResourceLocation, EntryStack> p_215394_) {
        for (EntryStack $$2 : p_215394_.values()) {
            if (p_215393_.isFiltered($$2.fileLocation)) {
                $$2.fileSources.clear();
                continue;
            }
            if (!p_215393_.isFiltered($$2.metadataLocation())) continue;
            $$2.metaSources.clear();
        }
    }

    private void listPackResources(PackEntry p_215388_, String p_215389_, Predicate<ResourceLocation> p_215390_, Map<ResourceLocation, EntryStack> p_215391_) {
        PackResources $$4 = p_215388_.resources;
        if ($$4 == null) {
            return;
        }
        $$4.listResources(this.type, this.namespace, p_215389_, (p_248266_, p_248267_) -> {
            if (FallbackResourceManager.isMetadata(p_248266_)) {
                ResourceLocation $$5 = FallbackResourceManager.getResourceLocationFromMetadata(p_248266_);
                if (!p_215390_.test($$5)) {
                    return;
                }
                p_248264_.computeIfAbsent($$5, (Function<ResourceLocation, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).metaSources.put($$4, (IoSupplier<InputStream>)p_248267_);
            } else {
                if (!p_215390_.test((ResourceLocation)p_248266_)) {
                    return;
                }
                p_248264_.computeIfAbsent(p_248266_, (Function<ResourceLocation, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).fileSources.add(new ResourceWithSource($$4, (IoSupplier<InputStream>)p_248267_));
            }
        });
    }

    @Override
    public Map<ResourceLocation, List<Resource>> listResourceStacks(String p_215416_, Predicate<ResourceLocation> p_215417_) {
        HashMap $$2 = Maps.newHashMap();
        for (PackEntry $$3 : this.fallbacks) {
            FallbackResourceManager.applyPackFiltersToExistingResources($$3, $$2);
            this.listPackResources($$3, p_215416_, p_215417_, $$2);
        }
        TreeMap $$4 = Maps.newTreeMap();
        for (EntryStack $$5 : $$2.values()) {
            if ($$5.fileSources.isEmpty()) continue;
            ArrayList<Resource> $$6 = new ArrayList<Resource>();
            for (ResourceWithSource $$7 : $$5.fileSources) {
                PackResources $$8 = $$7.source;
                IoSupplier<InputStream> $$9 = $$5.metaSources.get($$8);
                IoSupplier<ResourceMetadata> $$10 = $$9 != null ? FallbackResourceManager.convertToMetadata($$9) : ResourceMetadata.EMPTY_SUPPLIER;
                $$6.add(FallbackResourceManager.createResource($$8, $$5.fileLocation, $$7.resource, $$10));
            }
            $$4.put($$5.fileLocation, $$6);
        }
        return $$4;
    }

    @Override
    public Stream<PackResources> listPacks() {
        return this.fallbacks.stream().map(p_215386_ -> p_215386_.resources).filter(Objects::nonNull);
    }

    record PackEntry(String name, @Nullable PackResources resources, @Nullable Predicate<ResourceLocation> filter) {
        public void filterAll(Collection<ResourceLocation> p_215443_) {
            if (this.filter != null) {
                p_215443_.removeIf(this.filter);
            }
        }

        public boolean isFiltered(ResourceLocation p_215441_) {
            return this.filter != null && this.filter.test(p_215441_);
        }
    }

    record EntryStack(ResourceLocation fileLocation, ResourceLocation metadataLocation, List<ResourceWithSource> fileSources, Map<PackResources, IoSupplier<InputStream>> metaSources) {
        EntryStack(ResourceLocation p_251350_) {
            this(p_251350_, FallbackResourceManager.getMetadataLocation(p_251350_), new ArrayList<ResourceWithSource>(), (Map<PackResources, IoSupplier<InputStream>>)new Object2ObjectArrayMap());
        }
    }

    record ResourceWithSource(PackResources source, IoSupplier<InputStream> resource) {
    }

    static class LeakedResourceWarningInputStream
    extends FilterInputStream {
        private final Supplier<String> message;
        private boolean closed;

        public LeakedResourceWarningInputStream(InputStream p_10633_, ResourceLocation p_10634_, String p_10635_) {
            super(p_10633_);
            Exception $$3 = new Exception("Stacktrace");
            this.message = () -> {
                StringWriter $$3 = new StringWriter();
                $$3.printStackTrace(new PrintWriter($$3));
                return "Leaked resource: '" + String.valueOf(p_10634_) + "' loaded from pack: '" + p_10635_ + "'\n" + String.valueOf($$3);
            };
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            if (!this.closed) {
                LOGGER.warn("{}", (Object)this.message.get());
            }
            super.finalize();
        }
    }
}

