/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.GuardianModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GuardianRenderer
extends MobRenderer<Guardian, GuardianModel> {
    private static final ResourceLocation GUARDIAN_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/guardian.png");
    private static final ResourceLocation GUARDIAN_BEAM_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.entityCutoutNoCull(GUARDIAN_BEAM_LOCATION);

    public GuardianRenderer(EntityRendererProvider.Context p_174159_) {
        this(p_174159_, 0.5f, ModelLayers.GUARDIAN);
    }

    protected GuardianRenderer(EntityRendererProvider.Context p_174161_, float p_174162_, ModelLayerLocation p_174163_) {
        super(p_174161_, new GuardianModel(p_174161_.bakeLayer(p_174163_)), p_174162_);
    }

    @Override
    public boolean shouldRender(Guardian p_114836_, Frustum p_114837_, double p_114838_, double p_114839_, double p_114840_) {
        LivingEntity $$5;
        if (super.shouldRender(p_114836_, p_114837_, p_114838_, p_114839_, p_114840_)) {
            return true;
        }
        if (p_114836_.hasActiveAttackTarget() && ($$5 = p_114836_.getActiveAttackTarget()) != null) {
            Vec3 $$6 = this.getPosition($$5, (double)$$5.getBbHeight() * 0.5, 1.0f);
            Vec3 $$7 = this.getPosition(p_114836_, p_114836_.getEyeHeight(), 1.0f);
            return p_114837_.isVisible(new AABB($$7.x, $$7.y, $$7.z, $$6.x, $$6.y, $$6.z));
        }
        return false;
    }

    private Vec3 getPosition(LivingEntity p_114803_, double p_114804_, float p_114805_) {
        double $$3 = Mth.lerp((double)p_114805_, p_114803_.xOld, p_114803_.getX());
        double $$4 = Mth.lerp((double)p_114805_, p_114803_.yOld, p_114803_.getY()) + p_114804_;
        double $$5 = Mth.lerp((double)p_114805_, p_114803_.zOld, p_114803_.getZ());
        return new Vec3($$3, $$4, $$5);
    }

    @Override
    public void render(Guardian p_114829_, float p_114830_, float p_114831_, PoseStack p_114832_, MultiBufferSource p_114833_, int p_114834_) {
        super.render(p_114829_, p_114830_, p_114831_, p_114832_, p_114833_, p_114834_);
        LivingEntity $$6 = p_114829_.getActiveAttackTarget();
        if ($$6 != null) {
            float $$7 = p_114829_.getAttackAnimationScale(p_114831_);
            float $$8 = p_114829_.getClientSideAttackTime() + p_114831_;
            float $$9 = $$8 * 0.5f % 1.0f;
            float $$10 = p_114829_.getEyeHeight();
            p_114832_.pushPose();
            p_114832_.translate(0.0f, $$10, 0.0f);
            Vec3 $$11 = this.getPosition($$6, (double)$$6.getBbHeight() * 0.5, p_114831_);
            Vec3 $$12 = this.getPosition(p_114829_, $$10, p_114831_);
            Vec3 $$13 = $$11.subtract($$12);
            float $$14 = (float)($$13.length() + 1.0);
            $$13 = $$13.normalize();
            float $$15 = (float)Math.acos($$13.y);
            float $$16 = (float)Math.atan2($$13.z, $$13.x);
            p_114832_.mulPose(Axis.YP.rotationDegrees((1.5707964f - $$16) * 57.295776f));
            p_114832_.mulPose(Axis.XP.rotationDegrees($$15 * 57.295776f));
            boolean $$17 = true;
            float $$18 = $$8 * 0.05f * -1.5f;
            float $$19 = $$7 * $$7;
            int $$20 = 64 + (int)($$19 * 191.0f);
            int $$21 = 32 + (int)($$19 * 191.0f);
            int $$22 = 128 - (int)($$19 * 64.0f);
            float $$23 = 0.2f;
            float $$24 = 0.282f;
            float $$25 = Mth.cos($$18 + 2.3561945f) * 0.282f;
            float $$26 = Mth.sin($$18 + 2.3561945f) * 0.282f;
            float $$27 = Mth.cos($$18 + 0.7853982f) * 0.282f;
            float $$28 = Mth.sin($$18 + 0.7853982f) * 0.282f;
            float $$29 = Mth.cos($$18 + 3.926991f) * 0.282f;
            float $$30 = Mth.sin($$18 + 3.926991f) * 0.282f;
            float $$31 = Mth.cos($$18 + 5.4977875f) * 0.282f;
            float $$32 = Mth.sin($$18 + 5.4977875f) * 0.282f;
            float $$33 = Mth.cos($$18 + (float)Math.PI) * 0.2f;
            float $$34 = Mth.sin($$18 + (float)Math.PI) * 0.2f;
            float $$35 = Mth.cos($$18 + 0.0f) * 0.2f;
            float $$36 = Mth.sin($$18 + 0.0f) * 0.2f;
            float $$37 = Mth.cos($$18 + 1.5707964f) * 0.2f;
            float $$38 = Mth.sin($$18 + 1.5707964f) * 0.2f;
            float $$39 = Mth.cos($$18 + 4.712389f) * 0.2f;
            float $$40 = Mth.sin($$18 + 4.712389f) * 0.2f;
            float $$41 = $$14;
            float $$42 = 0.0f;
            float $$43 = 0.4999f;
            float $$44 = -1.0f + $$9;
            float $$45 = $$14 * 2.5f + $$44;
            VertexConsumer $$46 = p_114833_.getBuffer(BEAM_RENDER_TYPE);
            PoseStack.Pose $$47 = p_114832_.last();
            GuardianRenderer.vertex($$46, $$47, $$33, $$41, $$34, $$20, $$21, $$22, 0.4999f, $$45);
            GuardianRenderer.vertex($$46, $$47, $$33, 0.0f, $$34, $$20, $$21, $$22, 0.4999f, $$44);
            GuardianRenderer.vertex($$46, $$47, $$35, 0.0f, $$36, $$20, $$21, $$22, 0.0f, $$44);
            GuardianRenderer.vertex($$46, $$47, $$35, $$41, $$36, $$20, $$21, $$22, 0.0f, $$45);
            GuardianRenderer.vertex($$46, $$47, $$37, $$41, $$38, $$20, $$21, $$22, 0.4999f, $$45);
            GuardianRenderer.vertex($$46, $$47, $$37, 0.0f, $$38, $$20, $$21, $$22, 0.4999f, $$44);
            GuardianRenderer.vertex($$46, $$47, $$39, 0.0f, $$40, $$20, $$21, $$22, 0.0f, $$44);
            GuardianRenderer.vertex($$46, $$47, $$39, $$41, $$40, $$20, $$21, $$22, 0.0f, $$45);
            float $$48 = 0.0f;
            if (p_114829_.tickCount % 2 == 0) {
                $$48 = 0.5f;
            }
            GuardianRenderer.vertex($$46, $$47, $$25, $$41, $$26, $$20, $$21, $$22, 0.5f, $$48 + 0.5f);
            GuardianRenderer.vertex($$46, $$47, $$27, $$41, $$28, $$20, $$21, $$22, 1.0f, $$48 + 0.5f);
            GuardianRenderer.vertex($$46, $$47, $$31, $$41, $$32, $$20, $$21, $$22, 1.0f, $$48);
            GuardianRenderer.vertex($$46, $$47, $$29, $$41, $$30, $$20, $$21, $$22, 0.5f, $$48);
            p_114832_.popPose();
        }
    }

    private static void vertex(VertexConsumer p_253637_, PoseStack.Pose p_323627_, float p_253994_, float p_254492_, float p_254474_, int p_254080_, int p_253655_, int p_254133_, float p_254233_, float p_253939_) {
        p_253637_.addVertex(p_323627_, p_253994_, p_254492_, p_254474_).setColor(p_254080_, p_253655_, p_254133_, 255).setUv(p_254233_, p_253939_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(p_323627_, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public ResourceLocation getTextureLocation(Guardian p_114827_) {
        return GUARDIAN_LOCATION;
    }
}

