/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.culling;

import net.minecraft.world.phys.AABB;
import org.joml.FrustumIntersection;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class Frustum {
    public static final int OFFSET_STEP = 4;
    private final FrustumIntersection intersection = new FrustumIntersection();
    private final Matrix4f matrix = new Matrix4f();
    private Vector4f viewVector;
    private double camX;
    private double camY;
    private double camZ;

    public Frustum(Matrix4f p_254207_, Matrix4f p_254535_) {
        this.calculateFrustum(p_254207_, p_254535_);
    }

    public Frustum(Frustum p_194440_) {
        this.intersection.set((Matrix4fc)p_194440_.matrix);
        this.matrix.set((Matrix4fc)p_194440_.matrix);
        this.camX = p_194440_.camX;
        this.camY = p_194440_.camY;
        this.camZ = p_194440_.camZ;
        this.viewVector = p_194440_.viewVector;
    }

    public Frustum offsetToFullyIncludeCameraCube(int p_194442_) {
        double $$1 = Math.floor(this.camX / (double)p_194442_) * (double)p_194442_;
        double $$2 = Math.floor(this.camY / (double)p_194442_) * (double)p_194442_;
        double $$3 = Math.floor(this.camZ / (double)p_194442_) * (double)p_194442_;
        double $$4 = Math.ceil(this.camX / (double)p_194442_) * (double)p_194442_;
        double $$5 = Math.ceil(this.camY / (double)p_194442_) * (double)p_194442_;
        double $$6 = Math.ceil(this.camZ / (double)p_194442_) * (double)p_194442_;
        while (this.intersection.intersectAab((float)($$1 - this.camX), (float)($$2 - this.camY), (float)($$3 - this.camZ), (float)($$4 - this.camX), (float)($$5 - this.camY), (float)($$6 - this.camZ)) != -2) {
            this.camX -= (double)(this.viewVector.x() * 4.0f);
            this.camY -= (double)(this.viewVector.y() * 4.0f);
            this.camZ -= (double)(this.viewVector.z() * 4.0f);
        }
        return this;
    }

    public void prepare(double p_113003_, double p_113004_, double p_113005_) {
        this.camX = p_113003_;
        this.camY = p_113004_;
        this.camZ = p_113005_;
    }

    private void calculateFrustum(Matrix4f p_253909_, Matrix4f p_254521_) {
        p_254521_.mul((Matrix4fc)p_253909_, this.matrix);
        this.intersection.set((Matrix4fc)this.matrix);
        this.viewVector = this.matrix.transformTranspose(new Vector4f(0.0f, 0.0f, 1.0f, 0.0f));
    }

    public boolean isVisible(AABB p_113030_) {
        return this.cubeInFrustum(p_113030_.minX, p_113030_.minY, p_113030_.minZ, p_113030_.maxX, p_113030_.maxY, p_113030_.maxZ);
    }

    private boolean cubeInFrustum(double p_113007_, double p_113008_, double p_113009_, double p_113010_, double p_113011_, double p_113012_) {
        float $$6 = (float)(p_113007_ - this.camX);
        float $$7 = (float)(p_113008_ - this.camY);
        float $$8 = (float)(p_113009_ - this.camZ);
        float $$9 = (float)(p_113010_ - this.camX);
        float $$10 = (float)(p_113011_ - this.camY);
        float $$11 = (float)(p_113012_ - this.camZ);
        return this.intersection.testAab($$6, $$7, $$8, $$9, $$10, $$11);
    }
}

