/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.main;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.logging.LogUtils;
import com.mojang.util.UndashedUuid;
import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.client.telemetry.TelemetryProperty;
import net.minecraft.client.telemetry.events.GameLoadTimesEvent;
import net.minecraft.core.UUIDUtil;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @DontObfuscate
    public static void main(String[] p_129642_) {
        void $$73;
        void $$72;
        OptionParser $$1 = new OptionParser();
        $$1.allowsUnrecognizedOptions();
        $$1.accepts("demo");
        $$1.accepts("disableMultiplayer");
        $$1.accepts("disableChat");
        $$1.accepts("fullscreen");
        $$1.accepts("checkGlErrors");
        OptionSpecBuilder $$2 = $$1.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec $$3 = $$1.accepts("quickPlayPath").withRequiredArg();
        ArgumentAcceptingOptionSpec $$4 = $$1.accepts("quickPlaySingleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec $$5 = $$1.accepts("quickPlayMultiplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec $$6 = $$1.accepts("quickPlayRealms").withRequiredArg();
        ArgumentAcceptingOptionSpec $$7 = $$1.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec $$8 = $$1.accepts("assetsDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec $$9 = $$1.accepts("resourcePackDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("proxyHost").withRequiredArg();
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("proxyPort").withRequiredArg().defaultsTo((Object)"8080", (Object[])new String[0]).ofType(Integer.class);
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("proxyUser").withRequiredArg();
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("proxyPass").withRequiredArg();
        ArgumentAcceptingOptionSpec $$14 = $$1.accepts("username").withRequiredArg().defaultsTo((Object)("Player" + System.currentTimeMillis() % 1000L), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$15 = $$1.accepts("uuid").withRequiredArg();
        ArgumentAcceptingOptionSpec $$16 = $$1.accepts("xuid").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$17 = $$1.accepts("clientId").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$18 = $$1.accepts("accessToken").withRequiredArg().required();
        ArgumentAcceptingOptionSpec $$19 = $$1.accepts("version").withRequiredArg().required();
        ArgumentAcceptingOptionSpec $$20 = $$1.accepts("width").withRequiredArg().ofType(Integer.class).defaultsTo((Object)854, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$21 = $$1.accepts("height").withRequiredArg().ofType(Integer.class).defaultsTo((Object)480, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$22 = $$1.accepts("fullscreenWidth").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec $$23 = $$1.accepts("fullscreenHeight").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec $$24 = $$1.accepts("userProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$25 = $$1.accepts("profileProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$26 = $$1.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec $$27 = $$1.accepts("userType").withRequiredArg().defaultsTo((Object)"legacy", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$28 = $$1.accepts("versionType").withRequiredArg().defaultsTo((Object)"release", (Object[])new String[0]);
        NonOptionArgumentSpec $$29 = $$1.nonOptions();
        OptionSet $$30 = $$1.parse(p_129642_);
        File $$31 = (File)Main.parseArgument($$30, $$7);
        String $$32 = (String)Main.parseArgument($$30, $$19);
        String $$33 = "Pre-bootstrap";
        try {
            String $$39;
            User.Type $$40;
            if ($$30.has((OptionSpec)$$2)) {
                JvmProfiler.INSTANCE.start(Environment.CLIENT);
            }
            Stopwatch $$34 = Stopwatch.createStarted((Ticker)Ticker.systemTicker());
            Stopwatch $$35 = Stopwatch.createStarted((Ticker)Ticker.systemTicker());
            GameLoadTimesEvent.INSTANCE.beginStep(TelemetryProperty.LOAD_TIME_TOTAL_TIME_MS, $$34);
            GameLoadTimesEvent.INSTANCE.beginStep(TelemetryProperty.LOAD_TIME_PRE_WINDOW_MS, $$35);
            SharedConstants.tryDetectVersion();
            CompletableFuture<?> $$36 = DataFixers.optimize(DataFixTypes.TYPES_FOR_LEVEL_LIST);
            CrashReport.preload();
            Logger $$37 = LogUtils.getLogger();
            $$33 = "Bootstrap";
            Bootstrap.bootStrap();
            GameLoadTimesEvent.INSTANCE.setBootstrapTime(Bootstrap.bootstrapDuration.get());
            Bootstrap.validate();
            $$33 = "Argument parsing";
            List $$38 = $$30.valuesOf((OptionSpec)$$29);
            if (!$$38.isEmpty()) {
                $$37.info("Completely ignored arguments: {}", (Object)$$38);
            }
            if (($$40 = User.Type.byName($$39 = (String)$$27.value($$30))) == null) {
                $$37.warn("Unrecognized user type: {}", (Object)$$39);
            }
            String $$41 = (String)Main.parseArgument($$30, $$10);
            Proxy $$42 = Proxy.NO_PROXY;
            if ($$41 != null) {
                try {
                    $$42 = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress($$41, (int)((Integer)Main.parseArgument($$30, $$11))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            final String $$43 = (String)Main.parseArgument($$30, $$12);
            final String $$44 = (String)Main.parseArgument($$30, $$13);
            if (!$$42.equals(Proxy.NO_PROXY) && Main.stringHasValue($$43) && Main.stringHasValue($$44)) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication($$43, $$44.toCharArray());
                    }
                });
            }
            int $$45 = (Integer)Main.parseArgument($$30, $$20);
            int $$46 = (Integer)Main.parseArgument($$30, $$21);
            OptionalInt $$47 = Main.ofNullable((Integer)Main.parseArgument($$30, $$22));
            OptionalInt $$48 = Main.ofNullable((Integer)Main.parseArgument($$30, $$23));
            boolean $$49 = $$30.has("fullscreen");
            boolean $$50 = $$30.has("demo");
            boolean $$51 = $$30.has("disableMultiplayer");
            boolean $$52 = $$30.has("disableChat");
            Gson $$53 = new GsonBuilder().registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create();
            PropertyMap $$54 = GsonHelper.fromJson($$53, (String)Main.parseArgument($$30, $$24), PropertyMap.class);
            PropertyMap $$55 = GsonHelper.fromJson($$53, (String)Main.parseArgument($$30, $$25), PropertyMap.class);
            String $$56 = (String)Main.parseArgument($$30, $$28);
            File $$57 = $$30.has((OptionSpec)$$8) ? (File)Main.parseArgument($$30, $$8) : new File($$31, "assets/");
            File $$58 = $$30.has((OptionSpec)$$9) ? (File)Main.parseArgument($$30, $$9) : new File($$31, "resourcepacks/");
            UUID $$59 = $$30.has((OptionSpec)$$15) ? UndashedUuid.fromStringLenient((String)((String)$$15.value($$30))) : UUIDUtil.createOfflinePlayerUUID((String)$$14.value($$30));
            String $$60 = $$30.has((OptionSpec)$$26) ? (String)$$26.value($$30) : null;
            String $$61 = (String)$$30.valueOf((OptionSpec)$$16);
            String $$62 = (String)$$30.valueOf((OptionSpec)$$17);
            String $$63 = (String)Main.parseArgument($$30, $$3);
            String $$64 = Main.unescapeJavaArgument((String)Main.parseArgument($$30, $$4));
            String $$65 = Main.unescapeJavaArgument((String)Main.parseArgument($$30, $$5));
            String $$66 = Main.unescapeJavaArgument((String)Main.parseArgument($$30, $$6));
            User $$67 = new User((String)$$14.value($$30), $$59, (String)$$18.value($$30), Main.emptyStringToEmptyOptional($$61), Main.emptyStringToEmptyOptional($$62), $$40);
            GameConfig $$68 = new GameConfig(new GameConfig.UserData($$67, $$54, $$55, $$42), new DisplayData($$45, $$46, $$47, $$48, $$49), new GameConfig.FolderData($$31, $$58, $$57, $$60), new GameConfig.GameData($$50, $$32, $$56, $$51, $$52), new GameConfig.QuickPlayData($$63, $$64, $$65, $$66));
            Util.startTimerHackThread();
            $$36.join();
        }
        catch (Throwable $$69) {
            CrashReport $$70 = CrashReport.forThrowable($$69, $$33);
            CrashReportCategory $$71 = $$70.addCategory("Initialization");
            NativeModuleLister.addCrashSection($$71);
            Minecraft.fillReport(null, null, $$32, null, $$70);
            Minecraft.crash(null, $$31, $$70);
            return;
        }
        Thread $$74 = new Thread("Client Shutdown Thread"){

            @Override
            public void run() {
                Minecraft $$0 = Minecraft.getInstance();
                if ($$0 == null) {
                    return;
                }
                IntegratedServer $$1 = $$0.getSingleplayerServer();
                if ($$1 != null) {
                    $$1.halt(true);
                }
            }
        };
        $$74.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler((Logger)$$72));
        Runtime.getRuntime().addShutdownHook($$74);
        Minecraft $$75 = null;
        try {
            Thread.currentThread().setName("Render thread");
            RenderSystem.initRenderThread();
            RenderSystem.beginInitialization();
            $$75 = new Minecraft((GameConfig)$$73);
            RenderSystem.finishInitialization();
        }
        catch (SilentInitException $$76) {
            Util.shutdownExecutors();
            $$72.warn("Failed to create window: ", (Throwable)$$76);
            return;
        }
        catch (Throwable $$77) {
            CrashReport $$78 = CrashReport.forThrowable($$77, "Initializing game");
            CrashReportCategory $$79 = $$78.addCategory("Initialization");
            NativeModuleLister.addCrashSection($$79);
            Minecraft.fillReport($$75, null, $$73.game.launchVersion, null, $$78);
            Minecraft.crash($$75, $$73.location.gameDirectory, $$78);
            return;
        }
        Minecraft $$80 = $$75;
        $$80.run();
        BufferUploader.reset();
        try {
            $$80.stop();
        }
        finally {
            $$80.destroy();
        }
    }

    @Nullable
    private static String unescapeJavaArgument(@Nullable String p_301984_) {
        if (p_301984_ == null) {
            return null;
        }
        return StringEscapeUtils.unescapeJava((String)p_301984_);
    }

    private static Optional<String> emptyStringToEmptyOptional(String p_195487_) {
        return p_195487_.isEmpty() ? Optional.empty() : Optional.of(p_195487_);
    }

    private static OptionalInt ofNullable(@Nullable Integer p_129635_) {
        return p_129635_ != null ? OptionalInt.of(p_129635_) : OptionalInt.empty();
    }

    @Nullable
    private static <T> T parseArgument(OptionSet p_129639_, OptionSpec<T> p_129640_) {
        try {
            return (T)p_129639_.valueOf(p_129640_);
        }
        catch (Throwable $$2) {
            ArgumentAcceptingOptionSpec $$3;
            List $$4;
            if (p_129640_ instanceof ArgumentAcceptingOptionSpec && !($$4 = ($$3 = (ArgumentAcceptingOptionSpec)p_129640_).defaultValues()).isEmpty()) {
                return (T)$$4.get(0);
            }
            throw $$2;
        }
    }

    private static boolean stringHasValue(@Nullable String p_129637_) {
        return p_129637_ != null && !p_129637_.isEmpty();
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }
}

