/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.gson.JsonObject;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.ValueObject;
import com.mojang.realmsclient.util.JsonUtils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.StringUtil;

public class RealmsWorldOptions
extends ValueObject {
    public final boolean pvp;
    public final boolean spawnAnimals;
    public final boolean spawnMonsters;
    public final boolean spawnNPCs;
    public final int spawnProtection;
    public final boolean commandBlocks;
    public final boolean forceGameMode;
    public final int difficulty;
    public final int gameMode;
    private final String slotName;
    public final String version;
    public final RealmsServer.Compatibility compatibility;
    public long templateId;
    @Nullable
    public String templateImage;
    public boolean empty;
    private static final boolean DEFAULT_FORCE_GAME_MODE = false;
    private static final boolean DEFAULT_PVP = true;
    private static final boolean DEFAULT_SPAWN_ANIMALS = true;
    private static final boolean DEFAULT_SPAWN_MONSTERS = true;
    private static final boolean DEFAULT_SPAWN_NPCS = true;
    private static final int DEFAULT_SPAWN_PROTECTION = 0;
    private static final boolean DEFAULT_COMMAND_BLOCKS = false;
    private static final int DEFAULT_DIFFICULTY = 2;
    private static final int DEFAULT_GAME_MODE = 0;
    private static final String DEFAULT_SLOT_NAME = "";
    private static final String DEFAULT_VERSION = "";
    private static final RealmsServer.Compatibility DEFAULT_COMPATIBILITY = RealmsServer.Compatibility.UNVERIFIABLE;
    private static final long DEFAULT_TEMPLATE_ID = -1L;
    private static final String DEFAULT_TEMPLATE_IMAGE = null;

    public RealmsWorldOptions(boolean p_167302_, boolean p_167303_, boolean p_167304_, boolean p_167305_, int p_167306_, boolean p_167307_, int p_167308_, int p_167309_, boolean p_167310_, String p_167311_, String p_307682_, RealmsServer.Compatibility p_307526_) {
        this.pvp = p_167302_;
        this.spawnAnimals = p_167303_;
        this.spawnMonsters = p_167304_;
        this.spawnNPCs = p_167305_;
        this.spawnProtection = p_167306_;
        this.commandBlocks = p_167307_;
        this.difficulty = p_167308_;
        this.gameMode = p_167309_;
        this.forceGameMode = p_167310_;
        this.slotName = p_167311_;
        this.version = p_307682_;
        this.compatibility = p_307526_;
    }

    public static RealmsWorldOptions createDefaults() {
        return new RealmsWorldOptions(true, true, true, true, 0, false, 2, 0, false, "", "", DEFAULT_COMPATIBILITY);
    }

    public static RealmsWorldOptions createEmptyDefaults() {
        RealmsWorldOptions $$0 = RealmsWorldOptions.createDefaults();
        $$0.setEmpty(true);
        return $$0;
    }

    public void setEmpty(boolean p_87631_) {
        this.empty = p_87631_;
    }

    public static RealmsWorldOptions parse(JsonObject p_87629_) {
        RealmsWorldOptions $$1 = new RealmsWorldOptions(JsonUtils.getBooleanOr("pvp", p_87629_, true), JsonUtils.getBooleanOr("spawnAnimals", p_87629_, true), JsonUtils.getBooleanOr("spawnMonsters", p_87629_, true), JsonUtils.getBooleanOr("spawnNPCs", p_87629_, true), JsonUtils.getIntOr("spawnProtection", p_87629_, 0), JsonUtils.getBooleanOr("commandBlocks", p_87629_, false), JsonUtils.getIntOr("difficulty", p_87629_, 2), JsonUtils.getIntOr("gameMode", p_87629_, 0), JsonUtils.getBooleanOr("forceGameMode", p_87629_, false), JsonUtils.getRequiredStringOr("slotName", p_87629_, ""), JsonUtils.getRequiredStringOr("version", p_87629_, ""), RealmsServer.getCompatibility(JsonUtils.getRequiredStringOr("compatibility", p_87629_, RealmsServer.Compatibility.UNVERIFIABLE.name())));
        $$1.templateId = JsonUtils.getLongOr("worldTemplateId", p_87629_, -1L);
        $$1.templateImage = JsonUtils.getStringOr("worldTemplateImage", p_87629_, DEFAULT_TEMPLATE_IMAGE);
        return $$1;
    }

    public String getSlotName(int p_87627_) {
        if (StringUtil.isBlank(this.slotName)) {
            if (this.empty) {
                return I18n.get("mco.configure.world.slot.empty", new Object[0]);
            }
            return this.getDefaultSlotName(p_87627_);
        }
        return this.slotName;
    }

    public String getDefaultSlotName(int p_87634_) {
        return I18n.get("mco.configure.world.slot", p_87634_);
    }

    public String toJson() {
        JsonObject $$0 = new JsonObject();
        if (!this.pvp) {
            $$0.addProperty("pvp", Boolean.valueOf(this.pvp));
        }
        if (!this.spawnAnimals) {
            $$0.addProperty("spawnAnimals", Boolean.valueOf(this.spawnAnimals));
        }
        if (!this.spawnMonsters) {
            $$0.addProperty("spawnMonsters", Boolean.valueOf(this.spawnMonsters));
        }
        if (!this.spawnNPCs) {
            $$0.addProperty("spawnNPCs", Boolean.valueOf(this.spawnNPCs));
        }
        if (this.spawnProtection != 0) {
            $$0.addProperty("spawnProtection", (Number)this.spawnProtection);
        }
        if (this.commandBlocks) {
            $$0.addProperty("commandBlocks", Boolean.valueOf(this.commandBlocks));
        }
        if (this.difficulty != 2) {
            $$0.addProperty("difficulty", (Number)this.difficulty);
        }
        if (this.gameMode != 0) {
            $$0.addProperty("gameMode", (Number)this.gameMode);
        }
        if (this.forceGameMode) {
            $$0.addProperty("forceGameMode", Boolean.valueOf(this.forceGameMode));
        }
        if (!Objects.equals(this.slotName, "")) {
            $$0.addProperty("slotName", this.slotName);
        }
        if (!Objects.equals(this.version, "")) {
            $$0.addProperty("version", this.version);
        }
        if (this.compatibility != DEFAULT_COMPATIBILITY) {
            $$0.addProperty("compatibility", this.compatibility.name());
        }
        return $$0.toString();
    }

    public RealmsWorldOptions clone() {
        return new RealmsWorldOptions(this.pvp, this.spawnAnimals, this.spawnMonsters, this.spawnNPCs, this.spawnProtection, this.commandBlocks, this.difficulty, this.gameMode, this.forceGameMode, this.slotName, this.version, this.compatibility);
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }
}

