/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.schedule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.entity.schedule.Keyframe;

public class Timeline {
    private final List<Keyframe> keyframes = Lists.newArrayList();
    private int previousIndex;

    public ImmutableList<Keyframe> getKeyframes() {
        return ImmutableList.copyOf(this.keyframes);
    }

    public Timeline addKeyframe(int p_38061_, float p_38062_) {
        this.keyframes.add(new Keyframe(p_38061_, p_38062_));
        this.sortAndDeduplicateKeyframes();
        return this;
    }

    public Timeline addKeyframes(Collection<Keyframe> p_150248_) {
        this.keyframes.addAll(p_150248_);
        this.sortAndDeduplicateKeyframes();
        return this;
    }

    private void sortAndDeduplicateKeyframes() {
        Int2ObjectAVLTreeMap $$0 = new Int2ObjectAVLTreeMap();
        this.keyframes.forEach(arg_0 -> Timeline.lambda$sortAndDeduplicateKeyframes$0((Int2ObjectSortedMap)$$0, arg_0));
        this.keyframes.clear();
        this.keyframes.addAll((Collection<Keyframe>)$$0.values());
        this.previousIndex = 0;
    }

    public float getValueAt(int p_38059_) {
        Keyframe $$7;
        if (this.keyframes.size() <= 0) {
            return 0.0f;
        }
        Keyframe $$1 = this.keyframes.get(this.previousIndex);
        Keyframe $$2 = this.keyframes.get(this.keyframes.size() - 1);
        boolean $$3 = p_38059_ < $$1.getTimeStamp();
        int $$4 = $$3 ? 0 : this.previousIndex;
        float $$5 = $$3 ? $$2.getValue() : $$1.getValue();
        int $$6 = $$4;
        while ($$6 < this.keyframes.size() && ($$7 = this.keyframes.get($$6)).getTimeStamp() <= p_38059_) {
            this.previousIndex = $$6++;
            $$5 = $$7.getValue();
        }
        return $$5;
    }

    private static /* synthetic */ void lambda$sortAndDeduplicateKeyframes$0(Int2ObjectSortedMap p_38064_, Keyframe p_38065_) {
        p_38064_.put(p_38065_.getTimeStamp(), (Object)p_38065_);
    }
}

