/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class RandomStroll {
    private static final int MAX_XZ_DIST = 10;
    private static final int MAX_Y_DIST = 7;
    private static final int[][] SWIM_XY_DISTANCE_TIERS = new int[][]{{1, 1}, {3, 3}, {5, 5}, {6, 5}, {7, 7}, {10, 7}};

    public static OneShot<PathfinderMob> stroll(float p_260304_) {
        return RandomStroll.stroll(p_260304_, true);
    }

    public static OneShot<PathfinderMob> stroll(float p_260303_, boolean p_259639_) {
        return RandomStroll.strollFlyOrSwim(p_260303_, p_258601_ -> LandRandomPos.getPos(p_258601_, 10, 7), p_259639_ ? p_258615_ -> true : p_350044_ -> !p_350044_.isInWaterOrBubble());
    }

    public static BehaviorControl<PathfinderMob> stroll(float p_260204_, int p_259502_, int p_259891_) {
        return RandomStroll.strollFlyOrSwim(p_260204_, p_258605_ -> LandRandomPos.getPos(p_258605_, p_259502_, p_259891_), p_258616_ -> true);
    }

    public static BehaviorControl<PathfinderMob> fly(float p_259119_) {
        return RandomStroll.strollFlyOrSwim(p_259119_, p_258614_ -> RandomStroll.getTargetFlyPos(p_258614_, 10, 7), p_258602_ -> true);
    }

    public static BehaviorControl<PathfinderMob> swim(float p_259469_) {
        return RandomStroll.strollFlyOrSwim(p_259469_, RandomStroll::getTargetSwimPos, Entity::isInWaterOrBubble);
    }

    private static OneShot<PathfinderMob> strollFlyOrSwim(float p_260030_, Function<PathfinderMob, Vec3> p_259912_, Predicate<PathfinderMob> p_259088_) {
        return BehaviorBuilder.create(p_258620_ -> p_258620_.group(p_258620_.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)p_258620_, p_258600_ -> (p_258610_, p_258611_, p_258612_) -> {
            if (!p_259088_.test((PathfinderMob)p_258611_)) {
                return false;
            }
            Optional<Vec3> $$7 = Optional.ofNullable((Vec3)p_259912_.apply((PathfinderMob)p_258611_));
            p_258600_.setOrErase($$7.map(p_258622_ -> new WalkTarget((Vec3)p_258622_, p_260030_, 0)));
            return true;
        }));
    }

    @Nullable
    private static Vec3 getTargetSwimPos(PathfinderMob p_259491_) {
        Vec3 $$1 = null;
        Vec3 $$2 = null;
        for (int[] $$3 : SWIM_XY_DISTANCE_TIERS) {
            $$2 = $$1 == null ? BehaviorUtils.getRandomSwimmablePos(p_259491_, $$3[0], $$3[1]) : p_259491_.position().add(p_259491_.position().vectorTo($$1).normalize().multiply($$3[0], $$3[1], $$3[0]));
            if ($$2 == null || p_259491_.level().getFluidState(BlockPos.containing($$2)).isEmpty()) {
                return $$1;
            }
            $$1 = $$2;
        }
        return $$2;
    }

    @Nullable
    private static Vec3 getTargetFlyPos(PathfinderMob p_260316_, int p_259038_, int p_259696_) {
        Vec3 $$3 = p_260316_.getViewVector(0.0f);
        return AirAndWaterRandomPos.getPos(p_260316_, p_259038_, p_259696_, -2, $$3.x, $$3.z, 1.5707963705062866);
    }
}

