/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class QuadrupedModel<T extends Entity>
extends AgeableListModel<T> {
    protected final ModelPart head;
    protected final ModelPart body;
    protected final ModelPart rightHindLeg;
    protected final ModelPart leftHindLeg;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart leftFrontLeg;

    protected QuadrupedModel(ModelPart p_170857_, boolean p_170858_, float p_170859_, float p_170860_, float p_170861_, float p_170862_, int p_170863_) {
        super(p_170858_, p_170859_, p_170860_, p_170861_, p_170862_, p_170863_);
        this.head = p_170857_.getChild("head");
        this.body = p_170857_.getChild("body");
        this.rightHindLeg = p_170857_.getChild("right_hind_leg");
        this.leftHindLeg = p_170857_.getChild("left_hind_leg");
        this.rightFrontLeg = p_170857_.getChild("right_front_leg");
        this.leftFrontLeg = p_170857_.getChild("left_front_leg");
    }

    public static MeshDefinition createBodyMesh(int p_170865_, CubeDeformation p_170866_) {
        MeshDefinition $$2 = new MeshDefinition();
        PartDefinition $$3 = $$2.getRoot();
        $$3.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, p_170866_), PartPose.offset(0.0f, 18 - p_170865_, -6.0f));
        $$3.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 8).addBox(-5.0f, -10.0f, -7.0f, 10.0f, 16.0f, 8.0f, p_170866_), PartPose.offsetAndRotation(0.0f, 17 - p_170865_, 2.0f, 1.5707964f, 0.0f, 0.0f));
        CubeListBuilder $$4 = CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, (float)p_170865_, 4.0f, p_170866_);
        $$3.addOrReplaceChild("right_hind_leg", $$4, PartPose.offset(-3.0f, 24 - p_170865_, 7.0f));
        $$3.addOrReplaceChild("left_hind_leg", $$4, PartPose.offset(3.0f, 24 - p_170865_, 7.0f));
        $$3.addOrReplaceChild("right_front_leg", $$4, PartPose.offset(-3.0f, 24 - p_170865_, -5.0f));
        $$3.addOrReplaceChild("left_front_leg", $$4, PartPose.offset(3.0f, 24 - p_170865_, -5.0f));
        return $$2;
    }

    @Override
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }

    @Override
    public void setupAnim(T p_103509_, float p_103510_, float p_103511_, float p_103512_, float p_103513_, float p_103514_) {
        this.head.xRot = p_103514_ * ((float)Math.PI / 180);
        this.head.yRot = p_103513_ * ((float)Math.PI / 180);
        this.rightHindLeg.xRot = Mth.cos(p_103510_ * 0.6662f) * 1.4f * p_103511_;
        this.leftHindLeg.xRot = Mth.cos(p_103510_ * 0.6662f + (float)Math.PI) * 1.4f * p_103511_;
        this.rightFrontLeg.xRot = Mth.cos(p_103510_ * 0.6662f + (float)Math.PI) * 1.4f * p_103511_;
        this.leftFrontLeg.xRot = Mth.cos(p_103510_ * 0.6662f) * 1.4f * p_103511_;
    }
}

