/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforgespi.language;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.neoforged.neoforgespi.language.IModFileInfo;
import org.objectweb.asm.Type;

public class ModFileScanData {
    private final Set<AnnotationData> annotations = new LinkedHashSet<AnnotationData>();
    private final Set<ClassData> classes = new LinkedHashSet<ClassData>();
    private final List<IModFileInfo> modFiles = new ArrayList<IModFileInfo>();

    public Set<ClassData> getClasses() {
        return this.classes;
    }

    public Set<AnnotationData> getAnnotations() {
        return this.annotations;
    }

    public Stream<AnnotationData> getAnnotatedBy(Class<? extends Annotation> type, ElementType elementType) {
        Type anType = Type.getType(type);
        return this.getAnnotations().stream().filter(ad -> ad.targetType == elementType && ad.annotationType.equals((Object)anType));
    }

    public void addModFileInfo(IModFileInfo info) {
        this.modFiles.add(info);
    }

    public List<IModFileInfo> getIModInfoData() {
        return this.modFiles;
    }

    public record AnnotationData(Type annotationType, ElementType targetType, Type clazz, String memberName, Map<String, Object> annotationData) {
    }

    public record ClassData(Type clazz, Type parent, Set<Type> interfaces) {
    }
}

