/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import com.google.common.collect.Streams;
import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.neoforged.fml.loading.moddiscovery.ModJarMetadata;
import net.neoforged.fml.loading.moddiscovery.locators.MinecraftModInfo;
import net.neoforged.fml.loading.moddiscovery.readers.JarModsDotTomlModFileReader;
import net.neoforged.fml.util.DevEnvUtils;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;

public class NeoForgeDevProvider
implements IModFileCandidateLocator {
    private final List<Path> paths;

    public NeoForgeDevProvider(List<Path> paths) {
        this.paths = paths;
    }

    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        Path minecraftResourcesRoot = null;
        String legacyClassPath = System.getProperty("legacyClassPath");
        if (legacyClassPath != null) {
            minecraftResourcesRoot = Arrays.stream(legacyClassPath.split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).filter(path -> path.getFileName().toString().contains("client-extra")).findFirst().orElse(null);
        }
        if (minecraftResourcesRoot == null) {
            minecraftResourcesRoot = DevEnvUtils.findFileSystemRootOfFileOnClasspath("assets/.mcassetsroot");
        }
        String[] packages = NeoForgeDevProvider.getNeoForgeSpecificPathPrefixes();
        Path minecraftResourcesPrefix = minecraftResourcesRoot;
        JarContents mcJarContents = new JarContentsBuilder().paths((Path[])Streams.concat((Stream[])new Stream[]{this.paths.stream(), Stream.of(minecraftResourcesRoot)}).toArray(Path[]::new)).pathFilter((entry, basePath) -> {
            if (basePath.equals(minecraftResourcesPrefix) || entry.endsWith("/")) {
                return true;
            }
            if (!entry.endsWith(".class")) {
                return false;
            }
            for (String pkg : packages) {
                if (!entry.startsWith(pkg)) continue;
                return false;
            }
            return true;
        }).build();
        ModJarMetadata mcJarMetadata = new ModJarMetadata(mcJarContents);
        SecureJar mcSecureJar = SecureJar.from((JarContents)mcJarContents, (JarMetadata)mcJarMetadata);
        IModFile minecraftModFile = IModFile.create(mcSecureJar, MinecraftModInfo::buildMinecraftModInfo);
        mcJarMetadata.setModFile(minecraftModFile);
        pipeline.addModFile(minecraftModFile);
        JarContents neoforgeJarContents = new JarContentsBuilder().paths((Path[])this.paths.toArray(Path[]::new)).pathFilter((entry, basePath) -> {
            if (!entry.endsWith(".class")) {
                return true;
            }
            for (String pkg : packages) {
                if (!entry.startsWith(pkg)) continue;
                return true;
            }
            return false;
        }).build();
        pipeline.addModFile(JarModsDotTomlModFileReader.createModFile(neoforgeJarContents, ModFileDiscoveryAttributes.DEFAULT));
    }

    private static String[] getNeoForgeSpecificPathPrefixes() {
        return new String[]{"net/neoforged/neoforge/", "META-INF/services/", "META-INF/coremods.json", "META-INF/neoforge.mods.toml"};
    }

    public String toString() {
        return "neoforge devenv provider (" + String.valueOf(this.paths) + ")";
    }
}

