/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class RegistryFileCodec<E>
implements Codec<Holder<E>> {
    private final ResourceKey<? extends Registry<E>> registryKey;
    private final Codec<E> elementCodec;
    private final boolean allowInline;

    public static <E> RegistryFileCodec<E> create(ResourceKey<? extends Registry<E>> p_135590_, Codec<E> p_135591_) {
        return RegistryFileCodec.create(p_135590_, p_135591_, true);
    }

    public static <E> RegistryFileCodec<E> create(ResourceKey<? extends Registry<E>> p_135593_, Codec<E> p_135594_, boolean p_135595_) {
        return new RegistryFileCodec<E>(p_135593_, p_135594_, p_135595_);
    }

    private RegistryFileCodec(ResourceKey<? extends Registry<E>> p_135574_, Codec<E> p_135575_, boolean p_135576_) {
        this.registryKey = p_135574_;
        this.elementCodec = p_135575_;
        this.allowInline = p_135576_;
    }

    public <T> DataResult<T> encode(Holder<E> p_206716_, DynamicOps<T> p_206717_, T p_206718_) {
        RegistryOps $$3;
        Optional $$4;
        if (p_206717_ instanceof RegistryOps && ($$4 = ($$3 = (RegistryOps)p_206717_).owner(this.registryKey)).isPresent()) {
            if (!p_206716_.canSerializeIn($$4.get())) {
                return DataResult.error(() -> "Element " + String.valueOf(p_206716_) + " is not valid in current registry set");
            }
            return (DataResult)p_206716_.unwrap().map(p_206714_ -> ResourceLocation.CODEC.encode((Object)p_206714_.location(), p_206717_, p_206718_), p_206710_ -> this.elementCodec.encode(p_206710_, p_206717_, p_206718_));
        }
        return this.elementCodec.encode(p_206716_.value(), p_206717_, p_206718_);
    }

    public <T> DataResult<Pair<Holder<E>, T>> decode(DynamicOps<T> p_135608_, T p_135609_) {
        if (p_135608_ instanceof RegistryOps) {
            RegistryOps $$2 = (RegistryOps)p_135608_;
            Optional $$3 = $$2.getter(this.registryKey);
            if ($$3.isEmpty()) {
                return DataResult.error(() -> "Registry does not exist: " + String.valueOf(this.registryKey));
            }
            HolderGetter $$4 = $$3.get();
            DataResult $$5 = ResourceLocation.CODEC.decode(p_135608_, p_135609_);
            if ($$5.result().isEmpty()) {
                if (!this.allowInline) {
                    return DataResult.error(() -> "Inline definitions not allowed here");
                }
                return this.elementCodec.decode(p_135608_, p_135609_).map(p_206720_ -> p_206720_.mapFirst(Holder::direct));
            }
            Pair $$6 = (Pair)$$5.result().get();
            ResourceKey $$7 = ResourceKey.create(this.registryKey, (ResourceLocation)$$6.getFirst());
            return $$4.get($$7).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Failed to get element " + String.valueOf($$7))).map(p_255658_ -> Pair.of((Object)p_255658_, (Object)$$6.getSecond())).setLifecycle(Lifecycle.stable());
        }
        return this.elementCodec.decode(p_135608_, p_135609_).map(p_214212_ -> p_214212_.mapFirst(Holder::direct));
    }

    public String toString() {
        return "RegistryFileCodec[" + String.valueOf(this.registryKey) + " " + String.valueOf(this.elementCodec) + "]";
    }

    public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
        return this.encode((Holder)object, dynamicOps, object2);
    }
}

