/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public class CompoundTag
implements Tag {
    public static final Codec<CompoundTag> CODEC = Codec.PASSTHROUGH.comapFlatMap(p_311527_ -> {
        Tag $$1 = (Tag)p_311527_.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        if ($$1 instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)$$1;
            return DataResult.success((Object)($$2 == p_311527_.getValue() ? $$2.copy() : $$2));
        }
        return DataResult.error(() -> "Not a compound tag: " + String.valueOf($$1));
    }, p_311526_ -> new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_311526_.copy()));
    private static final int SELF_SIZE_IN_BYTES = 48;
    private static final int MAP_ENTRY_SIZE_IN_BYTES = 32;
    public static final TagType<CompoundTag> TYPE = new TagType.VariableSize<CompoundTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompoundTag load(DataInput p_128485_, NbtAccounter p_128487_) throws IOException {
            p_128487_.pushDepth();
            try {
                CompoundTag compoundTag = 1.loadCompound(p_128485_, p_128487_);
                return compoundTag;
            }
            finally {
                p_128487_.popDepth();
            }
        }

        private static CompoundTag loadCompound(DataInput p_302338_, NbtAccounter p_302362_) throws IOException {
            byte $$3;
            p_302362_.accountBytes(48L);
            HashMap $$2 = Maps.newHashMap();
            while (($$3 = p_302338_.readByte()) != 0) {
                Tag $$5;
                String $$4 = 1.readString(p_302338_, p_302362_);
                if ($$2.put($$4, $$5 = CompoundTag.readNamedTagData(TagTypes.getType($$3), $$4, p_302338_, p_302362_)) != null) continue;
                p_302362_.accountBytes(36L);
            }
            return new CompoundTag($$2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197446_, StreamTagVisitor p_197447_, NbtAccounter p_302322_) throws IOException {
            p_302322_.pushDepth();
            try {
                StreamTagVisitor.ValueResult valueResult = 1.parseCompound(p_197446_, p_197447_, p_302322_);
                return valueResult;
            }
            finally {
                p_302322_.popDepth();
            }
        }

        private static StreamTagVisitor.ValueResult parseCompound(DataInput p_302325_, StreamTagVisitor p_302352_, NbtAccounter p_302355_) throws IOException {
            byte $$3;
            p_302355_.accountBytes(48L);
            block13: while (($$3 = p_302325_.readByte()) != 0) {
                TagType<?> $$4 = TagTypes.getType($$3);
                switch (p_302352_.visitEntry($$4)) {
                    case HALT: {
                        return StreamTagVisitor.ValueResult.HALT;
                    }
                    case BREAK: {
                        StringTag.skipString(p_302325_);
                        $$4.skip(p_302325_, p_302355_);
                        break block13;
                    }
                    case SKIP: {
                        StringTag.skipString(p_302325_);
                        $$4.skip(p_302325_, p_302355_);
                        continue block13;
                    }
                    default: {
                        String $$5 = 1.readString(p_302325_, p_302355_);
                        switch (p_302352_.visitEntry($$4, $$5)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                            case BREAK: {
                                $$4.skip(p_302325_, p_302355_);
                                break block13;
                            }
                            case SKIP: {
                                $$4.skip(p_302325_, p_302355_);
                                continue block13;
                            }
                        }
                        p_302355_.accountBytes(36L);
                        switch ($$4.parse(p_302325_, p_302352_, p_302355_)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if ($$3 != 0) {
                while (($$3 = p_302325_.readByte()) != 0) {
                    StringTag.skipString(p_302325_);
                    TagTypes.getType($$3).skip(p_302325_, p_302355_);
                }
            }
            return p_302352_.visitContainerEnd();
        }

        private static String readString(DataInput p_302484_, NbtAccounter p_302494_) throws IOException {
            String $$2 = p_302484_.readUTF();
            p_302494_.accountBytes(28L);
            p_302494_.accountBytes(2L, $$2.length());
            return $$2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput p_197444_, NbtAccounter p_302358_) throws IOException {
            p_302358_.pushDepth();
            try {
                byte $$2;
                while (($$2 = p_197444_.readByte()) != 0) {
                    StringTag.skipString(p_197444_);
                    TagTypes.getType($$2).skip(p_197444_, p_302358_);
                }
            }
            finally {
                p_302358_.popDepth();
            }
        }

        @Override
        public String getName() {
            return "COMPOUND";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Compound";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private final Map<String, Tag> tags;

    protected CompoundTag(Map<String, Tag> p_128333_) {
        this.tags = p_128333_;
    }

    public CompoundTag() {
        this(Maps.newHashMap());
    }

    @Override
    public void write(DataOutput p_128341_) throws IOException {
        for (String $$1 : this.tags.keySet()) {
            Tag $$2 = this.tags.get($$1);
            CompoundTag.writeNamedTag($$1, $$2, p_128341_);
        }
        p_128341_.writeByte(0);
    }

    @Override
    public int sizeInBytes() {
        int $$0 = 48;
        for (Map.Entry<String, Tag> $$1 : this.tags.entrySet()) {
            $$0 += 28 + 2 * $$1.getKey().length();
            $$0 += 36;
            $$0 += $$1.getValue().sizeInBytes();
        }
        return $$0;
    }

    public Set<String> getAllKeys() {
        return this.tags.keySet();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public TagType<CompoundTag> getType() {
        return TYPE;
    }

    public int size() {
        return this.tags.size();
    }

    @Nullable
    public Tag put(String p_128366_, Tag p_128367_) {
        return this.tags.put(p_128366_, p_128367_);
    }

    public void putByte(String p_128345_, byte p_128346_) {
        this.tags.put(p_128345_, ByteTag.valueOf(p_128346_));
    }

    public void putShort(String p_128377_, short p_128378_) {
        this.tags.put(p_128377_, ShortTag.valueOf(p_128378_));
    }

    public void putInt(String p_128406_, int p_128407_) {
        this.tags.put(p_128406_, IntTag.valueOf(p_128407_));
    }

    public void putLong(String p_128357_, long p_128358_) {
        this.tags.put(p_128357_, LongTag.valueOf(p_128358_));
    }

    public void putUUID(String p_128363_, UUID p_128364_) {
        this.tags.put(p_128363_, NbtUtils.createUUID(p_128364_));
    }

    public UUID getUUID(String p_128343_) {
        return NbtUtils.loadUUID(this.get(p_128343_));
    }

    public boolean hasUUID(String p_128404_) {
        Tag $$1 = this.get(p_128404_);
        return $$1 != null && $$1.getType() == IntArrayTag.TYPE && ((IntArrayTag)$$1).getAsIntArray().length == 4;
    }

    public void putFloat(String p_128351_, float p_128352_) {
        this.tags.put(p_128351_, FloatTag.valueOf(p_128352_));
    }

    public void putDouble(String p_128348_, double p_128349_) {
        this.tags.put(p_128348_, DoubleTag.valueOf(p_128349_));
    }

    public void putString(String p_128360_, String p_128361_) {
        this.tags.put(p_128360_, StringTag.valueOf(p_128361_));
    }

    public void putByteArray(String p_128383_, byte[] p_128384_) {
        this.tags.put(p_128383_, new ByteArrayTag(p_128384_));
    }

    public void putByteArray(String p_177854_, List<Byte> p_177855_) {
        this.tags.put(p_177854_, new ByteArrayTag(p_177855_));
    }

    public void putIntArray(String p_128386_, int[] p_128387_) {
        this.tags.put(p_128386_, new IntArrayTag(p_128387_));
    }

    public void putIntArray(String p_128409_, List<Integer> p_128410_) {
        this.tags.put(p_128409_, new IntArrayTag(p_128410_));
    }

    public void putLongArray(String p_128389_, long[] p_128390_) {
        this.tags.put(p_128389_, new LongArrayTag(p_128390_));
    }

    public void putLongArray(String p_128429_, List<Long> p_128430_) {
        this.tags.put(p_128429_, new LongArrayTag(p_128430_));
    }

    public void putBoolean(String p_128380_, boolean p_128381_) {
        this.tags.put(p_128380_, ByteTag.valueOf(p_128381_));
    }

    @Nullable
    public Tag get(String p_128424_) {
        return this.tags.get(p_128424_);
    }

    public byte getTagType(String p_128436_) {
        Tag $$1 = this.tags.get(p_128436_);
        if ($$1 == null) {
            return 0;
        }
        return $$1.getId();
    }

    public boolean contains(String p_128442_) {
        return this.tags.containsKey(p_128442_);
    }

    public boolean contains(String p_128426_, int p_128427_) {
        byte $$2 = this.getTagType(p_128426_);
        if ($$2 == p_128427_) {
            return true;
        }
        if (p_128427_ == 99) {
            return $$2 == 1 || $$2 == 2 || $$2 == 3 || $$2 == 4 || $$2 == 5 || $$2 == 6;
        }
        return false;
    }

    public byte getByte(String p_128446_) {
        try {
            if (this.contains(p_128446_, 99)) {
                return ((NumericTag)this.tags.get(p_128446_)).getAsByte();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short getShort(String p_128449_) {
        try {
            if (this.contains(p_128449_, 99)) {
                return ((NumericTag)this.tags.get(p_128449_)).getAsShort();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int getInt(String p_128452_) {
        try {
            if (this.contains(p_128452_, 99)) {
                return ((NumericTag)this.tags.get(p_128452_)).getAsInt();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long getLong(String p_128455_) {
        try {
            if (this.contains(p_128455_, 99)) {
                return ((NumericTag)this.tags.get(p_128455_)).getAsLong();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float getFloat(String p_128458_) {
        try {
            if (this.contains(p_128458_, 99)) {
                return ((NumericTag)this.tags.get(p_128458_)).getAsFloat();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double getDouble(String p_128460_) {
        try {
            if (this.contains(p_128460_, 99)) {
                return ((NumericTag)this.tags.get(p_128460_)).getAsDouble();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String getString(String p_128462_) {
        try {
            if (this.contains(p_128462_, 8)) {
                return this.tags.get(p_128462_).getAsString();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] getByteArray(String p_128464_) {
        try {
            if (this.contains(p_128464_, 7)) {
                return ((ByteArrayTag)this.tags.get(p_128464_)).getAsByteArray();
            }
        }
        catch (ClassCastException $$1) {
            throw new ReportedException(this.createReport(p_128464_, ByteArrayTag.TYPE, $$1));
        }
        return new byte[0];
    }

    public int[] getIntArray(String p_128466_) {
        try {
            if (this.contains(p_128466_, 11)) {
                return ((IntArrayTag)this.tags.get(p_128466_)).getAsIntArray();
            }
        }
        catch (ClassCastException $$1) {
            throw new ReportedException(this.createReport(p_128466_, IntArrayTag.TYPE, $$1));
        }
        return new int[0];
    }

    public long[] getLongArray(String p_128468_) {
        try {
            if (this.contains(p_128468_, 12)) {
                return ((LongArrayTag)this.tags.get(p_128468_)).getAsLongArray();
            }
        }
        catch (ClassCastException $$1) {
            throw new ReportedException(this.createReport(p_128468_, LongArrayTag.TYPE, $$1));
        }
        return new long[0];
    }

    public CompoundTag getCompound(String p_128470_) {
        try {
            if (this.contains(p_128470_, 10)) {
                return (CompoundTag)this.tags.get(p_128470_);
            }
        }
        catch (ClassCastException $$1) {
            throw new ReportedException(this.createReport(p_128470_, TYPE, $$1));
        }
        return new CompoundTag();
    }

    public ListTag getList(String p_128438_, int p_128439_) {
        try {
            if (this.getTagType(p_128438_) == 9) {
                ListTag $$2 = (ListTag)this.tags.get(p_128438_);
                if ($$2.isEmpty() || $$2.getElementType() == p_128439_) {
                    return $$2;
                }
                return new ListTag();
            }
        }
        catch (ClassCastException $$3) {
            throw new ReportedException(this.createReport(p_128438_, ListTag.TYPE, $$3));
        }
        return new ListTag();
    }

    public boolean getBoolean(String p_128472_) {
        return this.getByte(p_128472_) != 0;
    }

    public void remove(String p_128474_) {
        this.tags.remove(p_128474_);
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    private CrashReport createReport(String p_128373_, TagType<?> p_128374_, ClassCastException p_128375_) {
        CrashReport $$3 = CrashReport.forThrowable(p_128375_, "Reading NBT data");
        CrashReportCategory $$4 = $$3.addCategory("Corrupt NBT tag", 1);
        $$4.setDetail("Tag type found", () -> this.tags.get(p_128373_).getType().getName());
        $$4.setDetail("Tag type expected", p_128374_::getName);
        $$4.setDetail("Tag name", p_128373_);
        return $$3;
    }

    protected CompoundTag shallowCopy() {
        return new CompoundTag(new HashMap<String, Tag>(this.tags));
    }

    @Override
    public CompoundTag copy() {
        HashMap $$0 = Maps.newHashMap((Map)Maps.transformValues(this.tags, Tag::copy));
        return new CompoundTag($$0);
    }

    public boolean equals(Object p_128444_) {
        if (this == p_128444_) {
            return true;
        }
        return p_128444_ instanceof CompoundTag && Objects.equals(this.tags, ((CompoundTag)p_128444_).tags);
    }

    public int hashCode() {
        return this.tags.hashCode();
    }

    private static void writeNamedTag(String p_128369_, Tag p_128370_, DataOutput p_128371_) throws IOException {
        p_128371_.writeByte(p_128370_.getId());
        if (p_128370_.getId() == 0) {
            return;
        }
        p_128371_.writeUTF(p_128369_);
        p_128370_.write(p_128371_);
    }

    static Tag readNamedTagData(TagType<?> p_128414_, String p_128415_, DataInput p_128416_, NbtAccounter p_128418_) {
        try {
            return p_128414_.load(p_128416_, p_128418_);
        }
        catch (IOException $$4) {
            CrashReport $$5 = CrashReport.forThrowable($$4, "Loading NBT data");
            CrashReportCategory $$6 = $$5.addCategory("NBT Tag");
            $$6.setDetail("Tag name", p_128415_);
            $$6.setDetail("Tag type", p_128414_.getName());
            throw new ReportedNbtException($$5);
        }
    }

    public CompoundTag merge(CompoundTag p_128392_) {
        for (String $$1 : p_128392_.tags.keySet()) {
            Tag $$2 = p_128392_.tags.get($$1);
            if ($$2.getId() == 10) {
                if (this.contains($$1, 10)) {
                    CompoundTag $$3 = this.getCompound($$1);
                    $$3.merge((CompoundTag)$$2);
                    continue;
                }
                this.put($$1, $$2.copy());
                continue;
            }
            this.put($$1, $$2.copy());
        }
        return this;
    }

    @Override
    public void accept(TagVisitor p_177857_) {
        p_177857_.visitCompound(this);
    }

    protected Set<Map.Entry<String, Tag>> entrySet() {
        return this.tags.entrySet();
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor p_197442_) {
        block14: for (Map.Entry<String, Tag> $$1 : this.tags.entrySet()) {
            Tag $$2 = $$1.getValue();
            TagType<?> $$3 = $$2.getType();
            StreamTagVisitor.EntryResult $$4 = p_197442_.visitEntry($$3);
            switch ($$4) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return p_197442_.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            $$4 = p_197442_.visitEntry($$3, $$1.getKey());
            switch ($$4) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return p_197442_.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            StreamTagVisitor.ValueResult $$5 = $$2.accept(p_197442_);
            switch ($$5) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return p_197442_.visitContainerEnd();
                }
            }
        }
        return p_197442_.visitContainerEnd();
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

