/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class FallingBlockRenderer
extends EntityRenderer<FallingBlockEntity> {
    private final BlockRenderDispatcher dispatcher;

    public FallingBlockRenderer(EntityRendererProvider.Context p_174112_) {
        super(p_174112_);
        this.shadowRadius = 0.5f;
        this.dispatcher = p_174112_.getBlockRenderDispatcher();
    }

    @Override
    public void render(FallingBlockEntity p_114634_, float p_114635_, float p_114636_, PoseStack p_114637_, MultiBufferSource p_114638_, int p_114639_) {
        BlockState $$6 = p_114634_.getBlockState();
        if ($$6.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        Level $$7 = p_114634_.level();
        if ($$6 == $$7.getBlockState(p_114634_.blockPosition()) || $$6.getRenderShape() == RenderShape.INVISIBLE) {
            return;
        }
        p_114637_.pushPose();
        BlockPos $$8 = BlockPos.containing(p_114634_.getX(), p_114634_.getBoundingBox().maxY, p_114634_.getZ());
        p_114637_.translate(-0.5, 0.0, -0.5);
        this.dispatcher.getModelRenderer().tesselateBlock($$7, this.dispatcher.getBlockModel($$6), $$6, $$8, p_114637_, p_114638_.getBuffer(ItemBlockRenderTypes.getMovingBlockRenderType($$6)), false, RandomSource.create(), $$6.getSeed(p_114634_.getStartPos()), OverlayTexture.NO_OVERLAY);
        p_114637_.popPose();
        super.render(p_114634_, p_114635_, p_114636_, p_114637_, p_114638_, p_114639_);
    }

    @Override
    public ResourceLocation getTextureLocation(FallingBlockEntity p_114632_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

