/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.ChunkPos;

public class SystemToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace("toast/system");
    private static final int MAX_LINE_SIZE = 200;
    private static final int LINE_SPACING = 12;
    private static final int MARGIN = 10;
    private final SystemToastId id;
    private Component title;
    private List<FormattedCharSequence> messageLines;
    private long lastChanged;
    private boolean changed;
    private final int width;
    private boolean forceHide;

    public SystemToast(SystemToastId p_314596_, Component p_94833_, @Nullable Component p_94834_) {
        this(p_314596_, p_94833_, (List<FormattedCharSequence>)SystemToast.nullToEmpty(p_94834_), Math.max(160, 30 + Math.max(Minecraft.getInstance().font.width(p_94833_), p_94834_ == null ? 0 : Minecraft.getInstance().font.width(p_94834_))));
    }

    public static SystemToast multiline(Minecraft p_94848_, SystemToastId p_314435_, Component p_94850_, Component p_94851_) {
        Font $$4 = p_94848_.font;
        List<FormattedCharSequence> $$5 = $$4.split(p_94851_, 200);
        int $$6 = Math.max(200, $$5.stream().mapToInt($$4::width).max().orElse(200));
        return new SystemToast(p_314435_, p_94850_, $$5, $$6 + 30);
    }

    private SystemToast(SystemToastId p_314467_, Component p_94828_, List<FormattedCharSequence> p_94829_, int p_94830_) {
        this.id = p_314467_;
        this.title = p_94828_;
        this.messageLines = p_94829_;
        this.width = p_94830_;
    }

    private static ImmutableList<FormattedCharSequence> nullToEmpty(@Nullable Component p_94861_) {
        return p_94861_ == null ? ImmutableList.of() : ImmutableList.of((Object)p_94861_.getVisualOrderText());
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return 20 + Math.max(this.messageLines.size(), 1) * 12;
    }

    public void forceHide() {
        this.forceHide = true;
    }

    @Override
    public Toast.Visibility render(GuiGraphics p_281624_, ToastComponent p_282333_, long p_282762_) {
        int $$3;
        if (this.changed) {
            this.lastChanged = p_282762_;
            this.changed = false;
        }
        if (($$3 = this.width()) == 160 && this.messageLines.size() <= 1) {
            p_281624_.blitSprite(BACKGROUND_SPRITE, 0, 0, $$3, this.height());
        } else {
            int $$4 = this.height();
            int $$5 = 28;
            int $$6 = Math.min(4, $$4 - 28);
            this.renderBackgroundRow(p_281624_, $$3, 0, 0, 28);
            for (int $$7 = 28; $$7 < $$4 - $$6; $$7 += 10) {
                this.renderBackgroundRow(p_281624_, $$3, 16, $$7, Math.min(16, $$4 - $$7 - $$6));
            }
            this.renderBackgroundRow(p_281624_, $$3, 32 - $$6, $$4 - $$6, $$6);
        }
        if (this.messageLines.isEmpty()) {
            p_281624_.drawString(p_282333_.getMinecraft().font, this.title, 18, 12, -256, false);
        } else {
            p_281624_.drawString(p_282333_.getMinecraft().font, this.title, 18, 7, -256, false);
            for (int $$8 = 0; $$8 < this.messageLines.size(); ++$$8) {
                p_281624_.drawString(p_282333_.getMinecraft().font, this.messageLines.get($$8), 18, 18 + $$8 * 12, -1, false);
            }
        }
        double $$9 = (double)this.id.displayTime * p_282333_.getNotificationDisplayTimeMultiplier();
        long $$10 = p_282762_ - this.lastChanged;
        return !this.forceHide && (double)$$10 < $$9 ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    private void renderBackgroundRow(GuiGraphics p_281840_, int p_281750_, int p_282371_, int p_283613_, int p_282880_) {
        int $$5 = p_282371_ == 0 ? 20 : 5;
        int $$6 = Math.min(60, p_281750_ - $$5);
        ResourceLocation $$7 = BACKGROUND_SPRITE;
        p_281840_.blitSprite($$7, 160, 32, 0, p_282371_, 0, p_283613_, $$5, p_282880_);
        for (int $$8 = $$5; $$8 < p_281750_ - $$6; $$8 += 64) {
            p_281840_.blitSprite($$7, 160, 32, 32, p_282371_, $$8, p_283613_, Math.min(64, p_281750_ - $$8 - $$6), p_282880_);
        }
        p_281840_.blitSprite($$7, 160, 32, 160 - $$6, p_282371_, p_281750_ - $$6, p_283613_, $$6, p_282880_);
    }

    public void reset(Component p_94863_, @Nullable Component p_94864_) {
        this.title = p_94863_;
        this.messageLines = SystemToast.nullToEmpty(p_94864_);
        this.changed = true;
    }

    @Override
    public SystemToastId getToken() {
        return this.id;
    }

    public static void add(ToastComponent p_94856_, SystemToastId p_314591_, Component p_94858_, @Nullable Component p_94859_) {
        p_94856_.addToast(new SystemToast(p_314591_, p_94858_, p_94859_));
    }

    public static void addOrUpdate(ToastComponent p_94870_, SystemToastId p_314579_, Component p_94872_, @Nullable Component p_94873_) {
        SystemToast $$4 = p_94870_.getToast(SystemToast.class, p_314579_);
        if ($$4 == null) {
            SystemToast.add(p_94870_, p_314579_, p_94872_, p_94873_);
        } else {
            $$4.reset(p_94872_, p_94873_);
        }
    }

    public static void forceHide(ToastComponent p_314559_, SystemToastId p_314474_) {
        SystemToast $$2 = p_314559_.getToast(SystemToast.class, p_314474_);
        if ($$2 != null) {
            $$2.forceHide();
        }
    }

    public static void onWorldAccessFailure(Minecraft p_94853_, String p_94854_) {
        SystemToast.add(p_94853_.getToasts(), SystemToastId.WORLD_ACCESS_FAILURE, Component.translatable("selectWorld.access_failure"), Component.literal(p_94854_));
    }

    public static void onWorldDeleteFailure(Minecraft p_94867_, String p_94868_) {
        SystemToast.add(p_94867_.getToasts(), SystemToastId.WORLD_ACCESS_FAILURE, Component.translatable("selectWorld.delete_failure"), Component.literal(p_94868_));
    }

    public static void onPackCopyFailure(Minecraft p_94876_, String p_94877_) {
        SystemToast.add(p_94876_.getToasts(), SystemToastId.PACK_COPY_FAILURE, Component.translatable("pack.copyFailure"), Component.literal(p_94877_));
    }

    public static void onFileDropFailure(Minecraft p_350375_, int p_350447_) {
        SystemToast.add(p_350375_.getToasts(), SystemToastId.FILE_DROP_FAILURE, Component.translatable("gui.fileDropFailure.title"), Component.translatable("gui.fileDropFailure.detail", p_350447_));
    }

    public static void onLowDiskSpace(Minecraft p_331174_) {
        SystemToast.addOrUpdate(p_331174_.getToasts(), SystemToastId.LOW_DISK_SPACE, Component.translatable("chunk.toast.lowDiskSpace"), Component.translatable("chunk.toast.lowDiskSpace.description"));
    }

    public static void onChunkLoadFailure(Minecraft p_330933_, ChunkPos p_331933_) {
        SystemToast.addOrUpdate(p_330933_.getToasts(), SystemToastId.CHUNK_LOAD_FAILURE, Component.translatable("chunk.toast.loadFailure", Component.translationArg(p_331933_)).withStyle(ChatFormatting.RED), Component.translatable("chunk.toast.checkLog"));
    }

    public static void onChunkSaveFailure(Minecraft p_331849_, ChunkPos p_330399_) {
        SystemToast.addOrUpdate(p_331849_.getToasts(), SystemToastId.CHUNK_SAVE_FAILURE, Component.translatable("chunk.toast.saveFailure", Component.translationArg(p_330399_)).withStyle(ChatFormatting.RED), Component.translatable("chunk.toast.checkLog"));
    }

    @Override
    public /* synthetic */ Object getToken() {
        return this.getToken();
    }

    public static class SystemToastId {
        public static final SystemToastId NARRATOR_TOGGLE = new SystemToastId();
        public static final SystemToastId WORLD_BACKUP = new SystemToastId();
        public static final SystemToastId PACK_LOAD_FAILURE = new SystemToastId();
        public static final SystemToastId WORLD_ACCESS_FAILURE = new SystemToastId();
        public static final SystemToastId PACK_COPY_FAILURE = new SystemToastId();
        public static final SystemToastId FILE_DROP_FAILURE = new SystemToastId();
        public static final SystemToastId PERIODIC_NOTIFICATION = new SystemToastId();
        public static final SystemToastId LOW_DISK_SPACE = new SystemToastId(10000L);
        public static final SystemToastId CHUNK_LOAD_FAILURE = new SystemToastId();
        public static final SystemToastId CHUNK_SAVE_FAILURE = new SystemToastId();
        public static final SystemToastId UNSECURE_SERVER_WARNING = new SystemToastId(10000L);
        final long displayTime;

        public SystemToastId(long p_314425_) {
            this.displayTime = p_314425_;
        }

        public SystemToastId() {
            this(5000L);
        }
    }
}

