/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.srgutils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.neoforged.srgutils.IMappingBuilder;
import net.neoforged.srgutils.IMappingFile;
import net.neoforged.srgutils.INamedMappingFile;
import net.neoforged.srgutils.InternalUtils;
import net.neoforged.srgutils.MappingFile;

class NamedMappingFile
implements INamedMappingFile,
IMappingBuilder {
    private final List<String> names;
    private Map<String, Package> packages = new HashMap<String, Package>();
    private Map<String, Cls> classes = new HashMap<String, Cls>();
    private Map<String, String[]> classCache = new ConcurrentHashMap<String, String[]>();
    private Map<String, IMappingFile> mapCache = new ConcurrentHashMap<String, IMappingFile>();

    NamedMappingFile(String ... names) {
        if (names == null || names.length < 2) {
            throw new IllegalArgumentException("Can not create Mapping file with less then two names");
        }
        this.names = Collections.unmodifiableList(Arrays.asList(names));
    }

    private void ensureCount(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("Names can not be null");
        }
        if (names.length != this.names.size()) {
            throw new IllegalArgumentException("Invalid number of names, expected " + this.names.size() + " got " + names.length);
        }
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public IMappingFile getMap(String from, String to) {
        String key = from + "_to_" + to;
        return this.mapCache.computeIfAbsent(key, k -> {
            int fromI = this.names.indexOf(from);
            int toI = this.names.indexOf(to);
            if (fromI == -1 || toI == -1) {
                throw new IllegalArgumentException("Could not find mapping names: " + from + " / " + to);
            }
            return new MappingFile(this, fromI, toI);
        });
    }

    @Override
    public void write(Path path, IMappingFile.Format format, String ... order) throws IOException {
        StringBuilder buf;
        if (order == null || order.length == 1) {
            throw new IllegalArgumentException("Invalid order, you must specify atleast 2 names");
        }
        if (!format.hasNames() && order.length > 2) {
            throw new IllegalArgumentException("Can not write " + order + " in " + format.name() + " format, it does not support headers");
        }
        int[] indexes = new int[order.length];
        for (int x = 0; x < order.length; ++x) {
            indexes[x] = this.getNames().indexOf(order[x]);
            if (indexes[x] != -1) continue;
            throw new IllegalArgumentException("Invalid order: Missing \"" + order[x] + "\" name");
        }
        ArrayList<String> lines = new ArrayList<String>();
        Comparator sort = (a, b) -> a.getName(indexes[0]).compareTo(b.getName(indexes[0]));
        this.getPackages().sorted(sort).forEachOrdered(pkg -> {
            lines.add(pkg.write(format, indexes));
            InternalUtils.writeMeta(format, lines, InternalUtils.Element.PACKAGE, pkg.meta);
        });
        this.getClasses().sorted(sort).forEachOrdered(cls -> {
            lines.add(cls.write(format, indexes));
            InternalUtils.writeMeta(format, lines, InternalUtils.Element.CLASS, cls.meta);
            cls.getFields().sorted(sort).forEachOrdered(fld -> {
                lines.add(fld.write(format, indexes));
                InternalUtils.writeMeta(format, lines, InternalUtils.Element.FIELD, fld.meta);
            });
            cls.getMethods().sorted(sort).forEachOrdered(mtd -> {
                lines.add(mtd.write(format, indexes));
                InternalUtils.writeMeta(format, lines, InternalUtils.Element.METHOD, mtd.meta);
                mtd.getParameters().sorted((a, b) -> a.getIndex() - b.getIndex()).forEachOrdered(par -> {
                    lines.add(par.write(format, indexes));
                    InternalUtils.writeMeta(format, lines, InternalUtils.Element.PARAMETER, par.meta);
                });
            });
        });
        lines.removeIf(e -> e == null);
        if (!format.isOrdered()) {
            Comparator linesort = format == IMappingFile.Format.SRG || format == IMappingFile.Format.XSRG ? InternalUtils::compareLines : (o1, o2) -> o1.compareTo((String)o2);
            Collections.sort(lines, linesort);
        }
        if (format == IMappingFile.Format.TINY1 || format == IMappingFile.Format.TINY) {
            buf = new StringBuilder();
            buf.append(format == IMappingFile.Format.TINY ? "tiny\t2\t0" : "v1");
            for (String name : order) {
                buf.append('\t').append(name);
            }
            lines.add(0, buf.toString());
        } else if (format == IMappingFile.Format.TSRG2) {
            buf = new StringBuilder();
            buf.append("tsrg2");
            for (String name : order) {
                buf.append(' ').append(name);
            }
            lines.add(0, buf.toString());
        }
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
        Object object = null;
        try {
            for (String line : lines) {
                writer.write(line);
                writer.write(10);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (object != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
    }

    private static <K, V> V retPut(Map<K, V> map, K key, V value) {
        map.put(key, value);
        return value;
    }

    private String remapClass(int index, String cls) {
        String[] ret;
        return ret[(ret = this.remapClass(cls)).length == 1 ? 0 : index];
    }

    private String[] remapClass(String cls) {
        String[] ret = this.classCache.get(cls);
        if (ret == null) {
            Cls _cls = this.classes.get(cls);
            if (_cls == null) {
                int idx = cls.lastIndexOf(36);
                if (idx != -1) {
                    String[] parent = this.remapClass(cls.substring(0, idx));
                    ret = new String[parent.length];
                    for (int x = 0; x < ret.length; ++x) {
                        ret[x] = parent[x] + '$' + cls.substring(idx + 1);
                    }
                } else {
                    ret = new String[]{cls};
                }
            } else {
                ret = _cls.getNames();
            }
            this.classCache.put(cls, ret);
        }
        return ret;
    }

    private String remapDescriptor(int index, String desc) {
        Matcher matcher = MappingFile.DESC.matcher(desc);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buf, Matcher.quoteReplacement("L" + this.remapClass(index, matcher.group("cls")) + ";"));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    Stream<Package> getPackages() {
        return this.packages.values().stream();
    }

    Stream<Cls> getClasses() {
        return this.classes.values().stream();
    }

    @Override
    public Package addPackage(String ... names) {
        this.ensureCount(names);
        return NamedMappingFile.retPut(this.packages, names[0], new Package(names));
    }

    @Override
    public Cls addClass(String ... names) {
        this.ensureCount(names);
        return NamedMappingFile.retPut(this.classes, names[0], new Cls(names));
    }

    @Override
    public INamedMappingFile build() {
        return this;
    }

    @Nullable
    Cls getClass(String name) {
        return this.classes.get(name);
    }

    class Cls
    extends Named
    implements IMappingBuilder.IClass {
        private final Map<String, Field> fields;
        private final Map<String, Method> methods;
        final Map<String, String> meta;

        Cls(String ... name) {
            super(name);
            this.fields = new HashMap<String, Field>();
            this.methods = new HashMap<String, Method>();
            this.meta = new LinkedHashMap<String, String>();
        }

        Stream<Field> getFields() {
            return this.fields.values().stream();
        }

        Stream<Method> getMethods() {
            return this.methods.values().stream();
        }

        @Override
        public Field field(String ... names) {
            NamedMappingFile.this.ensureCount(names);
            return (Field)NamedMappingFile.retPut(this.fields, names[0], new Field(names));
        }

        @Override
        public Method method(String desc, String ... names) {
            NamedMappingFile.this.ensureCount(names);
            return (Method)NamedMappingFile.retPut(this.methods, names[0] + desc, new Method(desc, names));
        }

        @Override
        public IMappingBuilder.IClass meta(String key, String value) {
            this.meta.put(key, value);
            return this;
        }

        @Override
        public IMappingBuilder build() {
            return NamedMappingFile.this;
        }

        @Override
        String write(IMappingFile.Format format, int ... order) {
            switch (format) {
                case SRG: 
                case XSRG: {
                    return "CL: " + this.getName(order[0]) + ' ' + this.getName(order[1]);
                }
                case CSRG: 
                case TSRG: {
                    return this.getName(order[0]) + ' ' + this.getName(order[1]);
                }
                case TSRG2: {
                    return this.getTsrg2(order);
                }
                case PG: {
                    return this.getName(order[0]).replace('/', '.') + " -> " + this.getName(order[1]).replace('/', '.') + ':';
                }
                case TINY1: {
                    return "CLASS" + this.getNames(order);
                }
                case TINY: {
                    return "c" + this.getNames(order);
                }
            }
            throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
        }

        private String getTsrg2(int ... order) {
            StringBuilder ret = new StringBuilder();
            for (int x = 0; x < order.length; ++x) {
                ret.append(this.getName(x));
                if (x == order.length - 1) continue;
                ret.append(' ');
            }
            return ret.toString();
        }

        class Method
        extends Named
        implements IMappingBuilder.IMethod {
            private final String desc;
            private final Map<Integer, Parameter> params;
            final Map<String, String> meta;

            Method(String desc, String ... names) {
                super(names);
                this.params = new HashMap<Integer, Parameter>();
                this.meta = new LinkedHashMap<String, String>();
                this.desc = desc;
            }

            @Override
            public IMappingBuilder.IParameter parameter(int index, String ... names) {
                NamedMappingFile.this.ensureCount(names);
                return (IMappingBuilder.IParameter)NamedMappingFile.retPut(this.params, index, new Parameter(index, names));
            }

            @Override
            public IMappingBuilder.IMethod meta(String key, String value) {
                this.meta.put(key, value);
                return this;
            }

            @Override
            public IMappingBuilder.IClass build() {
                return Cls.this;
            }

            public String getDescriptor(int index) {
                return index == 0 ? this.desc : NamedMappingFile.this.remapDescriptor(index, this.desc);
            }

            Stream<Parameter> getParameters() {
                return this.params.values().stream();
            }

            @Override
            String write(IMappingFile.Format format, int ... order) {
                String oOwner = Cls.this.getName(order[0]);
                String oName = this.getName(order[0]);
                String mName = this.getName(order[1]);
                String oDesc = this.getDescriptor(order[0]);
                switch (format) {
                    case SRG: 
                    case XSRG: {
                        return "MD: " + oOwner + '/' + oName + ' ' + oDesc + ' ' + Cls.this.getName(order[1]) + '/' + mName + ' ' + this.getDescriptor(order[1]);
                    }
                    case CSRG: {
                        return oOwner + ' ' + oName + ' ' + oDesc + ' ' + mName;
                    }
                    case TSRG: {
                        return '\t' + oName + ' ' + oDesc + ' ' + mName;
                    }
                    case TSRG2: {
                        return this.getTsrg2(order);
                    }
                    case TINY1: {
                        return "METHOD\t" + oOwner + '\t' + oDesc + this.getNames(order);
                    }
                    case TINY: {
                        return "\tm\t" + oDesc + this.getNames(order);
                    }
                    case PG: {
                        int start = Integer.parseInt(this.meta.getOrDefault("start_line", "0"));
                        int end = Integer.parseInt(this.meta.getOrDefault("end_line", "0"));
                        return "    " + (start == 0 && end == 0 ? "" : start + ":" + end + ":") + InternalUtils.toSource(oName, oDesc) + " -> " + mName;
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }

            private String getTsrg2(int ... order) {
                StringBuilder ret = new StringBuilder().append('\t');
                for (int x = 0; x < order.length; ++x) {
                    ret.append(this.getName(x));
                    if (x == 0 && this.getDescriptor(order[x]) != null) {
                        ret.append(' ').append(this.getDescriptor(order[x]));
                    }
                    if (x == order.length - 1) continue;
                    ret.append(' ');
                }
                return ret.toString();
            }

            class Parameter
            extends Named
            implements IMappingBuilder.IParameter {
                private final int index;
                final Map<String, String> meta;

                Parameter(int index, String ... names) {
                    super(names);
                    this.meta = new LinkedHashMap<String, String>();
                    this.index = index;
                }

                public int getIndex() {
                    return this.index;
                }

                @Override
                String write(IMappingFile.Format format, int ... order) {
                    switch (format) {
                        case SRG: 
                        case XSRG: 
                        case CSRG: 
                        case TSRG: 
                        case PG: 
                        case TINY1: {
                            return null;
                        }
                        case TINY: {
                            return "\t\tp\t" + this.getIndex() + this.getNames(order);
                        }
                        case TSRG2: {
                            return this.getTsrg2(order);
                        }
                    }
                    throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
                }

                private String getTsrg2(int ... order) {
                    StringBuilder ret = new StringBuilder().append("\t\t").append(this.getIndex());
                    for (int x = 0; x < order.length; ++x) {
                        ret.append(' ').append(this.getName(x));
                    }
                    return ret.toString();
                }

                @Override
                public IMappingBuilder.IParameter meta(String key, String value) {
                    this.meta.put(key, value);
                    return this;
                }

                @Override
                public IMappingBuilder.IMethod build() {
                    return Method.this;
                }
            }
        }

        class Field
        extends Named
        implements IMappingBuilder.IField {
            @Nullable
            private String desc;
            final Map<String, String> meta;

            Field(String ... names) {
                super(names);
                this.meta = new LinkedHashMap<String, String>();
            }

            public String getDescriptor(int index) {
                return this.desc == null ? null : (index == 0 ? this.desc : NamedMappingFile.this.remapDescriptor(index, this.desc));
            }

            @Override
            public IMappingBuilder.IField descriptor(String value) {
                this.desc = value;
                return this;
            }

            @Override
            public IMappingBuilder.IField meta(String key, String value) {
                this.meta.put(key, value);
                return this;
            }

            @Override
            public IMappingBuilder.IClass build() {
                return Cls.this;
            }

            @Override
            String write(IMappingFile.Format format, int ... order) {
                switch (format) {
                    case SRG: {
                        return "FD: " + Cls.this.getName(order[0]) + '/' + this.getName(order[0]) + ' ' + Cls.this.getName(order[1]) + '/' + this.getName(order[1]) + (this.desc == null ? "" : this.getDescriptor(order[0]) + ' ' + this.getDescriptor(order[1]));
                    }
                    case XSRG: {
                        return "FD: " + Cls.this.getName(order[0]) + '/' + this.getName(order[0]) + (this.desc == null ? "" : this.getDescriptor(order[0])) + ' ' + Cls.this.getName(order[1]) + '/' + this.getName(order[1]) + (this.desc == null ? "" : this.getDescriptor(order[1]));
                    }
                    case CSRG: {
                        return Cls.this.getName(order[0]) + ' ' + this.getName(order[0]) + ' ' + this.getName(order[1]);
                    }
                    case TSRG: {
                        return '\t' + this.getName(order[0]) + ' ' + this.getName(order[1]);
                    }
                    case TSRG2: {
                        return this.getTsrg2(order);
                    }
                    case PG: {
                        return "    " + InternalUtils.toSource(this.getDescriptor(order[0])) + ' ' + this.getName(order[0]) + " -> " + this.getName(order[1]);
                    }
                    case TINY1: {
                        return "FIELD\t" + Cls.this.getName(order[0]) + '\t' + this.getDescriptor(order[0]) + this.getNames(order);
                    }
                    case TINY: {
                        return "\tf\t" + this.getDescriptor(order[0]) + this.getNames(order);
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }

            private String getTsrg2(int ... order) {
                StringBuilder ret = new StringBuilder().append('\t');
                for (int x = 0; x < order.length; ++x) {
                    ret.append(this.getName(x));
                    if (x == 0 && this.getDescriptor(order[x]) != null) {
                        ret.append(' ').append(this.getDescriptor(order[x]));
                    }
                    if (x == order.length - 1) continue;
                    ret.append(' ');
                }
                return ret.toString();
            }
        }
    }

    class Package
    extends Named
    implements IMappingBuilder.IPackage {
        final Map<String, String> meta;

        Package(String ... names) {
            super(names);
            this.meta = new LinkedHashMap<String, String>();
        }

        @Override
        String write(IMappingFile.Format format, int ... order) {
            switch (format) {
                case SRG: 
                case XSRG: {
                    return "PK: " + this.getName(order[0]) + ' ' + this.getName(order[1]);
                }
                case CSRG: 
                case TSRG: {
                    return this.getName(order[0]) + "/ " + this.getName(order[1]) + '/';
                }
                case TSRG2: {
                    return this.getTsrg2(order);
                }
                case PG: 
                case TINY1: 
                case TINY: {
                    return null;
                }
            }
            throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
        }

        private String getTsrg2(int ... order) {
            StringBuilder ret = new StringBuilder();
            for (int x = 0; x < order.length; ++x) {
                ret.append(this.getName(x)).append('/');
                if (x == order.length - 1) continue;
                ret.append(' ');
            }
            return ret.toString();
        }

        @Override
        public IMappingBuilder.IPackage meta(String key, String value) {
            this.meta.put(key, value);
            return this;
        }

        @Override
        public IMappingBuilder build() {
            return NamedMappingFile.this;
        }
    }

    abstract class Named {
        private final String[] names;

        Named(String ... names) {
            this.names = names;
        }

        public String getName(int index) {
            return this.names[index];
        }

        String[] getNames() {
            return this.names;
        }

        protected String getNames(int ... order) {
            StringBuilder ret = new StringBuilder();
            for (int index : order) {
                ret.append('\t').append(this.getName(index));
            }
            return ret.toString();
        }

        abstract String write(IMappingFile.Format var1, int ... var2);
    }
}

